package com.gogirl.interfaces.wxappmember.store;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.store.store.StoreClassesService;
import com.gogirl.application.store.store.StoreClassesTechnicianService;
import com.gogirl.application.store.store.StoreTechnicianService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.store.store.StoreClasses;
import com.gogirl.domain.store.store.StoreClassesTechnician;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.domain.xcx.SysLog;
import com.gogirl.dto.ParmTechnicianClasses;
import com.gogirl.infrastructure.common.annotation.GogirlShop;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.mapper.store.StoreClassesTechnicianMapper;
import com.gogirl.infrastructure.mapper.xcx.SysLogMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = {"11.美甲师排班"}, value = "美甲师排班")
@RestController
@RequestMapping("classestechnician")
@Slf4j
@AllArgsConstructor
public class ClassesTechnicianController {


    private final StoreClassesTechnicianService storeClassesTechnicianService;
    private final GogirlTokenService gogirlTokenService;
    private final StoreClassesService storeClassesService;
    private final StoreTechnicianService storeTechnicianService;

    private final StoreClassesTechnicianMapper storeClassesTechnicianMapper;
    private final SysLogMapper sysLogMapper;

    @ApiOperation(value = "美甲师端查询当天店铺排班")
    @RequestMapping(method = {RequestMethod.GET}, value = "queryDayTechnicianClasses")
    @GogirlShop
    public JsonResult<List<StoreTechnician>> queryDayTechnicianClasses(String token, String dayString) throws ParseException {
        GogirlToken gogirlToken = gogirlTokenService.getTokenByToken_t(token);

        Date day = new SimpleDateFormat("yyyy-MM-dd").parse(dayString);

        Integer departmentId = gogirlToken.getStoreTechnician().getDepartmentId();

        //查询店铺下的美甲师
        List<StoreTechnician> list = storeTechnicianService.queryDayTechnicianClasses(departmentId, day);
        List<StoreClasses> classList = storeClassesService.list(new LambdaQueryWrapper<StoreClasses>().eq(StoreClasses::getDepartmentId, departmentId));

        //处理一个对应关系只返回012
        Map<Integer, Integer> map = new HashMap<>();
        map.put(0, 0);
        for (StoreClasses item : classList) {
            if (item.getName().equals("早班")) {
                map.put(item.getId(), 1);
            } else if (item.getName().equals("晚班")) {
                map.put(item.getId(), 2);
            }
        }
        //根据map对应关系转换class
        for (StoreTechnician item : list) {
            item.setId(item.getTechnicianId());
            if (item.getClassesTechnician() != null) {
                item.getClassesTechnician().setClasses(map.get(item.getClassesTechnician().getClasses()));
            }
        }
        return new JsonResult<>(true, JsonResult.APP_DEFINE_SUC, list);
    }


    @ApiOperation(value = "美甲师端提交当天店铺排班", notes = "{\"dayString\":\"2019-08-28\",\"list\":[{\"id\":59,\"classesTechnician\":{\"classes\":1,\"id\":5678}},{\"id\":62,\"classesTechnician\":{\"classes\":2,\"id\":5709}}],\"token\":\"3a18ea5546\"}")
    @RequestMapping(method = {RequestMethod.POST}, value = "updateDayTechnicianClasses")
    @GogirlShop
    public JsonResult<Object> updateDayTechnicianClasses(@RequestBody ParmTechnicianClasses ParmTechnicianClasses) {

        String token = ParmTechnicianClasses.getToken();

        String dayString = ParmTechnicianClasses.getDayString();

        GogirlToken gogirlToken = gogirlTokenService.getTokenByToken_t(token);

        if (gogirlToken == null) {
            return new JsonResult<>(false, "TOKEN_NULL_CODE");
        }
        if (gogirlToken.getStoreTechnician() == null) {
            return new JsonResult<>(false, "找不到美甲师");
        }

        Date day;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            day = sdf.parse(dayString);
        } catch (Exception e) {
            return new JsonResult<>(false, "day格式为yyyy-MM-dd");
        }

        //店铺id
        Integer departmentId = gogirlToken.getStoreTechnician().getDepartmentId();

        //查询店铺下的早晚修排班
        List<StoreClasses> classList = storeClassesService.list(new LambdaQueryWrapper<StoreClasses>().eq(StoreClasses::getDepartmentId, departmentId));

        Map<Integer, Integer> map = new HashMap<>();//处理一个对应关系只返回012
        map.put(0, 0);
        for (StoreClasses item : classList) {
            //早班
            if (item.getName().equals("早班")) {
                map.put(1, item.getId());
            }
            //晚班
            else if (item.getName().equals("晚班")) {
                map.put(2, item.getId());
            }
        }
        List<StoreClassesTechnician> oldVal = storeClassesTechnicianMapper.listByDepartmentIdAndDays(departmentId, ParmTechnicianClasses.getDayString());

        List<StoreTechnician> list = ParmTechnicianClasses.getList();
        for (int i = 0; i < list.size(); i++) {
            StoreTechnician item = list.get(i);
            if (item.getId() == null) {
                return new JsonResult<>(false, "第" + (i + 1) + "个美甲师id不能为空");
            }
            if (item.getClassesTechnician() == null) {
                return new JsonResult<>(false, "第" + (i + 1) + "个美甲师排班classesTechnician不能为空");
            }
            //修改早晚班为对应的classid
            if (item.getClassesTechnician().getClasses() != null) {
                item.getClassesTechnician().setClasses(map.get(item.getClassesTechnician().getClasses()));
            }
            if (item.getClassesTechnician().getClasses() != null && item.getClassesTechnician().getId() != null) {
                storeClassesTechnicianService.updateClassesTechnician(item.getClassesTechnician());
            }
            //
            else if (item.getClassesTechnician().getClasses() != null) {
                StoreClassesTechnician storeClassesTechnician = new StoreClassesTechnician();
                storeClassesTechnician.setUserId(item.getId());
                storeClassesTechnician.setDays(day);
                List<StoreClassesTechnician> hasClass = storeClassesTechnicianService.listClassesTechnicianDetailByDays(item.getId(), dayString);
                if (hasClass != null && hasClass.size() > 0) {
                    item.getClassesTechnician().setId(hasClass.get(0).getId());
                    storeClassesTechnicianService.updateClassesTechnician(item.getClassesTechnician());
                }
                //
                else {
                    item.getClassesTechnician().setUserId(item.getId());
                    item.getClassesTechnician().setDays(day);
                    item.getClassesTechnician().setStatus(2);
                    storeClassesTechnicianService.insertClassesTechnician(item.getClassesTechnician());
                }
            }
        }

        List<StoreClassesTechnician> newVal = storeClassesTechnicianMapper.listByDepartmentIdAndDays(departmentId, ParmTechnicianClasses.getDayString());
        SysLog sysLog = SysLog.builder()
                .createDate(new Date())
                .createUser(gogirlToken.getStoreTechnician().getTechnicianId())
                .createUserName(gogirlToken.getStoreTechnician().getName())
                .oldVal(JsonUtilByFsJson.beanToJson(oldVal))
                .newVal(JsonUtilByFsJson.beanToJson(newVal))
                .tableName("store_classes")
                .field("")
                .build();

        sysLogMapper.insert(sysLog);

        return new JsonResult<>(true, JsonResult.APP_DEFINE_SUC, null);
    }


    @ApiOperation(value = "美甲师端查询当月排班排班")
    @RequestMapping(method = {RequestMethod.GET}, value = "queryMonthClasses")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "month", value = "年月：2019-08", required = true, dataType = "String"),
            @ApiImplicitParam(name = "technicianId", value = "美甲师id:59", required = true, dataType = "int"),
            @ApiImplicitParam(name = "token", value = "token", required = true, dataType = "String")
    })
    @GogirlShop
    public JsonResult<List<StoreClassesTechnician>> queryMonthClasses(String token, Integer technicianId, String month) {
        GogirlToken gogirlToken = gogirlTokenService.getTokenByToken_t(token);
        if (gogirlToken == null) {
            return new JsonResult<>(false, "TOKEN_NULL_CODE");
        }
        if (gogirlToken.getStoreTechnician() == null) {
            return new JsonResult<>(false, "找不到美甲师");
        }
        Integer departmentId = gogirlToken.getStoreTechnician().getDepartmentId();

        List<StoreClasses> classList = storeClassesService.list(new LambdaQueryWrapper<StoreClasses>().eq(StoreClasses::getDepartmentId, departmentId));


        Map<Integer, Integer> map = new HashMap<Integer, Integer>();//处理一个对应关系只返回012
        map.put(0, 0);
        for (int i = 0; i < classList.size(); i++) {
            StoreClasses item = classList.get(i);
            if (item.getName().equals("早班")) {
                map.put(item.getId(), 1);
            } else if (item.getName().equals("晚班")) {
                map.put(item.getId(), 2);
            }
        }

        List<StoreClassesTechnician> lists = storeClassesTechnicianService.listClassesTechnicianDetail(gogirlToken.getStoreTechnician().getTechnicianId(), month);
        //替换排班的class
        for (StoreClassesTechnician item : lists) {
            item.setClasses(map.get(item.getClasses()));
        }
        return new JsonResult<>(true, JsonResult.APP_DEFINE_SUC, lists);
    }

}
