package com.gogirl.interfaces.wxappmember.product.serve;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.gogirl.application.product.serve.BaseProduceService;
import com.gogirl.application.product.serve.BaseServeService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.market.discount.LeisureDiscountConfig;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.product.serve.PraiseRecord;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.annotation.GogirlMember;
import com.gogirl.infrastructure.common.annotation.GogirlShop;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.mapper.market.LeisureDiscountConfigMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseServeMapper;
import com.gogirl.infrastructure.mapper.product.serve.PraiseRecordMapper;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@Api(tags = {"version2.0 服务管理"}, value = "version2.0 服务管理")
@AllArgsConstructor
public class ServeController {

    private final BaseServeService baseServeService;
    private final BaseProduceService baseProduceService;
    private final GogirlTokenService tokenService;
    private final PraiseRecordMapper praiseRecordMapper;
    private final LeisureDiscountConfigMapper leisureDiscountConfigMapper;
    private final BaseServeMapper baseServeMapper;

    @GetMapping("/customer/serve/no_queryNewServePage")
    @ApiOperation(value = "款式列表")
    public JsonResult<PageInfo<BaseServe>> no_queryNewServePage(@RequestParam String token,
                                                                @RequestParam(required = false) Integer labelId,
                                                                @RequestParam(required = false) Integer serveLabelId,
                                                                @RequestParam(required = false) Integer pageNum,
                                                                @RequestParam(required = false) Integer pageSize) {
        GogirlToken gogirlToken = tokenService.getTokenByToken(token);

        if (labelId != null && labelId == -1) {
            labelId = null;
        }

        //分页
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage(pageNum, pageSize);
        }
        //是否登陆
        Integer customerId = (gogirlToken != null && gogirlToken.getCustomerId() != null) ? gogirlToken.getCustomerId() : null;

        List<BaseProduce> listsBaseProduce = baseProduceService.queryNewServePage(customerId, labelId);

        List<BaseServe> lists = listsBaseProduce.stream()
                .map(baseProduce -> {
                    BaseServe item = baseProduce.getServe();
                    baseProduce.setServe(null);
                    item.setProduce(baseProduce);
                    return item;
                })
                .collect(Collectors.toList());

        return JsonResult.success(new PageInfo<>(lists));
    }

    @PostMapping("/customer/serve/praiseProduce")
    @ApiOperation(value = "款式点赞和取消点赞", notes = "款式点赞")
    public JsonResult<Void> praiseProduce(@RequestHeader String token,
                                          @RequestParam Integer produceId) {
        GogirlToken gogirlToken = tokenService.getTokenByToken(token);

        BaseProduce baseProduce = baseProduceService.getProduceForDetail(produceId);
        if (baseProduce == null) {
            throw new RRException("款式不存在");
        }
        Integer praiseSum = baseProduce.getPraiseSum();
        if (praiseSum == null) {
            praiseSum = 0;
        }

        //查看用户有没有点赞过，如果有，取消点赞，如果没有，点赞
        PraiseRecord paramPraise = new PraiseRecord();
        paramPraise.setCustomerId(gogirlToken.getCustomerId());
        paramPraise.setServeId(produceId);
        PraiseRecord praiseRecord = praiseRecordMapper.selectByCustomerIdAndServe(paramPraise);

        //点赞
        if (praiseRecord == null) {
            BaseProduce updateProduce = new BaseProduce();
            updateProduce.setId(produceId);
            updateProduce.setPraiseSum(++praiseSum);
            baseProduceService.updateProduceById(updateProduce);

            PraiseRecord updatePraise = new PraiseRecord();
            updatePraise.setCustomerId(gogirlToken.getCustomerId());
            updatePraise.setServeId(produceId);
            updatePraise.setTime(new Date());
            //1.服务;2.款式type
            updatePraise.setType(2);
            praiseRecordMapper.insert(updatePraise);
        }
        //取消点赞
        else {
            BaseProduce updateProduce = new BaseProduce();
            updateProduce.setId(produceId);
            updateProduce.setPraiseSum(--praiseSum);
            baseProduceService.updateProduceById(updateProduce);
            praiseRecordMapper.deleteById(praiseRecord.getId());
        }

        return JsonResult.success();
    }

    @ApiOperation(value = "查看服务详情", notes = "查看服务详情")
    @GetMapping("/customer/serve/getServeDetail")
    public JsonResult<BaseServe> getServeDetail(@RequestParam Integer id,
                                                String time) {
        BaseServe baseServe = baseServeService.getAggregate(id);
        Date today = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        int weekday = c.get(Calendar.DAY_OF_WEEK);
        if (weekday == 1) weekday = 7;
        else weekday = weekday - 1;

        if (StringUtils.isNotEmpty(time)) {
            LeisureDiscountConfig leisureDiscountConfig = leisureDiscountConfigMapper.selectLeisureDiscount(id, time, weekday);
            if (leisureDiscountConfig != null)
                baseServe.setDiscountRate(leisureDiscountConfig.getDiscountRate());
        }

        return JsonResult.success(baseServe);
    }

    @ApiOperation(value = "查看服务列表")
    @GetMapping("/customer/serve/no_queryServeForPage")
    public JsonResult<PageInfo<BaseServe>> no_queryServeForPage(BaseServe param,
                                                                Integer pageNum,
                                                                Integer pageSize,
                                                                Integer labelId,
                                                                String serveIds,
                                                                String time) {
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage(pageNum, pageSize);
        }
        if (labelId != null && labelId == -1) {
            labelId = null;
        }
        List<Integer> serveIdList;
        if (StringUtils.isNotEmpty(serveIds)) {
            serveIdList = Lists.newArrayList(serveIds.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList());
        } else {
            serveIdList = new ArrayList<>();
        }

        Date today = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        int weekday = c.get(Calendar.DAY_OF_WEEK);
        if (weekday == 1) weekday = 7;
        else weekday = weekday - 1;

        param.setServeLabelId(labelId);
        List<BaseServe> baseServeList;
        if (StringUtils.isEmpty(time))
            baseServeList = baseServeService.listServeForPage(param, serveIdList);
        else
            baseServeList = baseServeMapper.listLeisureServeForPage(param, serveIdList, time, weekday);

        return JsonResult.success(new PageInfo<>(baseServeList));
    }

    @ApiOperation(value = "查看服务详情", notes = "查看服务详情")
    @RequestMapping(method = {RequestMethod.GET}, value = "/technician/serve/getServeDetail")
    @GogirlMember
    @GogirlShop
    public JsonResult<BaseServe> getServeDetail(Integer id) {
        BaseServe baseServe = baseServeService.getAggregate(id);
        return JsonResult.success(baseServe);
    }


    @RequestMapping(method = {RequestMethod.GET, RequestMethod.POST}, value = "/technician/serve/queryServeForPage")
    @GogirlMember
    @GogirlShop
    @ApiOperation(value = "查询服务款式", notes = "查看服务列表")
    public JsonResult<PageInfo<BaseServe>> queryServeForPage(BaseServe baseServe,
                                                             @RequestParam(required = false) Integer pageNum,
                                                             @RequestParam(required = false) Integer pageSize) {
        JsonResult<PageInfo<BaseServe>> jsonResult = new JsonResult<>();

        if (pageNum != null && pageSize != null) {
            PageHelper.startPage(pageNum, pageSize);
        }

        List<BaseServe> lists = baseServeService.listServeForPage(baseServe, null);
        PageInfo<BaseServe> pageInfo = new PageInfo<>(lists);
        jsonResult.setSuccess(JsonResult.CODE_SUCCESS).setMessage(JsonResult.APP_DEFINE_SUC).setData(pageInfo);
        return jsonResult;
    }

}
