package com.gogirl.interfaces.wxappmember.product.serve;

import com.gogirl.application.product.serve.BaseProduceService;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.interfaces.wxappmember.product.serve.facade.resp.QueryProduceDetailRespDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = {"version2.0 服务管理"}, value = "version 2.0 服务管理")
@RestController
@AllArgsConstructor
public class ProduceController {

    private final BaseProduceService baseProduceService;

    @ApiOperation(value = "查询款式详情", notes = "查询款式详情")
    @GetMapping("/customer/produce/queryProduceDetail")
    public JsonResult<BaseProduce> queryProduceDetail(Integer id) {
        BaseProduce baseProduce = baseProduceService.getProduceForDetail(id);
        return JsonResult.success(baseProduce);
    }

    @ApiOperation(value = "查询款式详情")
    @GetMapping("/customer/produce/queryProduceDetail2")
    public JsonResult<QueryProduceDetailRespDTO> queryProduceDetail2(@RequestParam Integer id) {


        BaseProduce produce = baseProduceService.getProduceForDetail(id);
        QueryProduceDetailRespDTO data = new QueryProduceDetailRespDTO();

        //款式
        data.setProduce(produce);
        //服务
        data.setServe(produce.getServe());
        return JsonResult.success(data);
    }


}
