package com.gogirl.interfaces.wxappmember.order.serve;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.order.serve.ScheduleManageService;
import com.gogirl.application.product.mall.PurchaseSkuService;
import com.gogirl.application.user.customer.CustomerBalanceService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.assembler.ScheduleManageDTOAssembler;
import com.gogirl.domain.order.serve.ScheduleManage;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.infrastructure.common.annotation.GogirlShop;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.interfaces.wxappmember.order.serve.facade.IdleTimeProgramQuery;
import com.gogirl.shared.order.serve.command.schedule.CancelScheduleCommand;
import com.gogirl.shared.order.serve.command.schedule.SubmitScheduleCommand;
import com.gogirl.shared.order.serve.command.schedule.UpdateScheduleCommand;
import com.gogirl.shared.order.serve.query.dto.IdleTimeDTO;
import com.gogirl.shared.order.serve.query.dto.ScheduleManageDTO;
import com.gogirl.shared.order.serve.query.qry.schedule.ScheduleManagePageQuery;
import com.gogirl.shared.order.serve.query.qry.schedule.ScheduleManageQuery;
import com.gogirl.shared.user.query.qry.VipServeQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Api(tags = "version3.0:预约接口", value = "version3.0:预约接口")
@RestController
@AllArgsConstructor
@Slf4j
public class ScheduleManageController {

    private final ScheduleManageService scheduleManageService;
    private final GogirlTokenService gogirlTokenService;
    private final CustomerBalanceService customerBalanceService;


    /**
     * rpc
     */
    private final ScheduleManageDTOAssembler scheduleManageDTOAssembler;
    private final PurchaseSkuService purchaseSkuService;

    @PostMapping("/customer/schedule/queryIdleTime")
    public JsonResult<List<IdleTimeDTO>> queryIdleTime(@RequestBody IdleTimeProgramQuery qry) throws ParseException {
        List<IdleTimeDTO> idleTimeDTOList = scheduleManageService.queryIdleTime(qry);
        return JsonResult.success(idleTimeDTOList);
    }

    @ApiOperation(value = "查询显示预约时间列表")
    @GetMapping("/customer/schedule/queryLeisureTime")

    public JsonResult<List<IdleTimeDTO>> queryLeisureTime(@RequestHeader String token,
                                                          @RequestParam Integer departmentId,
                                                          @RequestParam String scheduleDate) throws ParseException {
        List<IdleTimeDTO> idleTimeDTOList = scheduleManageService.queryLeisureTime(departmentId, scheduleDate);
        return JsonResult.success(idleTimeDTOList);
    }

    @ApiOperation("提交预约")
    @PostMapping("/customer/schedule/submitSchedule")
    public JsonResult<Void> submitSchedule(@RequestHeader String token,
                                           @RequestBody SubmitScheduleCommand cmd) {
        Integer currentCustomerId = Optional.ofNullable(gogirlTokenService.getTokenByToken(token).getCustomerId())
                .orElseThrow(() -> new RRException(500, "token不存在"));
        cmd.getScheduleManageDTO().setScheduledUser(currentCustomerId);
        scheduleManageService.submitSchedule(cmd);
        return JsonResult.success();
    }

    @ApiOperation(value = "用户取消预约")
    @PostMapping("/customer/schedule/cancelOrder")
    public JsonResult<Void> cancelSchedule(@RequestBody CancelScheduleCommand cmd) {
        scheduleManageService.cancelSchedule(cmd);
        return JsonResult.success();
    }

    @ApiOperation("更新预约")
    @PostMapping("/customer/schedule/updateSchedule")
    public JsonResult<Void> updateSchedule(@RequestHeader String token,
                                           @RequestBody UpdateScheduleCommand cmd) {
        log.info("更新预约:{}", cmd);
        Integer currentCustomerId = Optional.ofNullable(gogirlTokenService.getTokenByToken(token).getCustomerId())
                .orElseThrow(() -> new RRException(500, "token不存在"));
        cmd.getScheduleManageDTO().setScheduledUser(currentCustomerId);
        scheduleManageService.updateSchedule(cmd);
        return JsonResult.success();
    }

    @ApiOperation(value = "根据id查询预约详情")
    @GetMapping("/customer/schedule/queryScheduleManage")
    public JsonResult<ScheduleManageDTO> queryScheduleManage(@RequestParam Integer id) {

        ScheduleManageQuery qry = new ScheduleManageQuery();
        qry.setScheduleManageId(id);
        ScheduleManage scheduleManage = scheduleManageService.queryScheduleManage(qry);
        return JsonResult.success(scheduleManageDTOAssembler.apply(scheduleManage));
    }

    @PostMapping("/customer/schedule/queryPageScheduleManage")
    @ApiOperation("/分页查询预约")
    public JsonResult<Page<ScheduleManageDTO>> queryPageScheduleManage(@RequestHeader String token,
                                                                       @RequestBody ScheduleManagePageQuery qry) {

        Integer currentCustomerId = Optional.ofNullable(gogirlTokenService.getTokenByToken(token).getCustomerId())
                .orElseThrow(() -> new RRException(500, "token不存在"));
        qry.setCustomerId(currentCustomerId);

        IPage<ScheduleManage> page = scheduleManageService.queryPageScheduleManage(qry);
        return JsonResult.success((Page<ScheduleManageDTO>) page.convert(scheduleManageDTOAssembler));
    }

    @ApiOperation("是否能够免费添加该服务")
    @PostMapping("/customer/schedule/checkVipServe")
    public JsonResult<Void> checkVipServe(@RequestHeader String token,
                                          @RequestParam Integer serveId) {

        Integer currentCustomerId = Optional.ofNullable(gogirlTokenService.getTokenByToken(token).getCustomerId())
                .orElseThrow(() -> new RRException(500, "token不存在"));

        VipServeQuery qry = new VipServeQuery();
        qry.setServeId(serveId);
        qry.setVipLevel(customerBalanceService.getCustomerBalance(currentCustomerId).getLevel());

//        JsonResult<VipServeDTO> result = vipControllerFeign.query(qry);
//        if (result.getData() == null) {
//            throw new RRException(1002, "会员才能享受服务");
//        }
        return JsonResult.success();
    }

    @ApiOperation(value = "店员查询可预约时间")
    @GetMapping("/technician/schedule/queryReservableTime")
    @GogirlShop
    public JsonResult<List<Map<String, Object>>> queryReservableTime(String startDate,
                                                                     Integer lengthTime,
                                                                     Integer departmentId,
                                                                     Integer orderId,
                                                                     Boolean needRemoveOldServe) {
        List<Map<String, Object>> result = scheduleManageService.queryReservableTime(startDate, lengthTime, departmentId, orderId, needRemoveOldServe);
        return JsonResult.success(result);
    }

    @PostMapping("/technician/schedule/queryPageScheduleManage")
    @ApiOperation("/店员分页查询预约")
    public JsonResult<Page<ScheduleManageDTO>> technicianQueryPageScheduleManage(@RequestHeader String token,
                                                                                 @RequestBody ScheduleManagePageQuery qry) {
        StoreTechnician storeTechnician = gogirlTokenService.getTokenByToken_t(token).getStoreTechnician();
        qry.setDepartmentId(storeTechnician.getDepartmentId());
        IPage<ScheduleManage> page = scheduleManageService.queryPageScheduleManage(qry);
        return JsonResult.success((Page<ScheduleManageDTO>) page.convert(scheduleManageDTOAssembler));
    }

    @ApiOperation(value = "根据id查询预约详情")
    @GetMapping("/technician/schedule/queryScheduleManage")
    public JsonResult<ScheduleManageDTO> technicianQueryScheduleManage(@RequestParam Integer id) {

        ScheduleManageQuery qry = new ScheduleManageQuery();
        qry.setScheduleManageId(id);
        ScheduleManage scheduleManage = scheduleManageService.queryScheduleManage(qry);

        ScheduleManageDTO scheduleManageDTO = scheduleManageDTOAssembler.apply(scheduleManage);

        scheduleManageDTO.getScheduleServeDTOList().forEach(scheduleServeDTO -> {
            //如果预约服务有款式 就查询款式使用色号
            if (scheduleServeDTO.getProduceId() != null) {
//                List<PurchaseSkuDTO> purchaseSkuDTOList =
//                        purchaseSkuService.
//                        purchaseSkuControllerFeign.queryByProduceId(scheduleServeDTO.getProduceId()).getData();
//                scheduleServeDTO.setPurchaseSkuDTOList(purchaseSkuDTOList);
            }
        });
        return JsonResult.success(scheduleManageDTO);
    }

    @ApiOperation("更新预约")
    @PostMapping("/technician/schedule/updateSchedule")
    public JsonResult<Void> updateSchedule(@RequestBody UpdateScheduleCommand cmd) {

        scheduleManageService.updateSchedule(cmd);
        return JsonResult.success();
    }

    @ApiOperation("更新前检查预约")
    @PostMapping("/technician/schedule/checkBeforeUpdate")
    public JsonResult<Void> checkBeforeUpdate(@RequestBody UpdateScheduleCommand cmd) {

        scheduleManageService.checkBeforeUpdate(cmd);
        return JsonResult.success();
    }


    @ApiOperation("更新预约服务状态")
    @GetMapping("/technician/schedule/updateScheduledServeStatus")
    public JsonResult<Void> updateScheduledServeStatus(@RequestHeader String token,
                                                       @RequestParam Integer scheduleServeId,
                                                       @RequestParam Integer status) {
        scheduleManageService.updateScheduledServeStatus(scheduleServeId, status);
        return JsonResult.success();
    }

}
