package com.gogirl.interfaces.wxappmember.order.serve;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.gogirl.domain.order.serve.OrderCommentLabel;
import com.gogirl.infrastructure.common.annotation.GogirlMember;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.mapper.order.serve.OrderCommentLabelMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Created by yinyong on 2018/10/22.
 */

@Api(tags = {"version2.0: 评论"}, value = "version2.0: 评论")
@RestController
@AllArgsConstructor
public class OrderCommentLabelController {

    private final OrderCommentLabelMapper orderCommentLabelMapper;

    /**
     * 查询所有评论标签
     *
     * @return 所有评论标签列表
     */
    @ApiOperation(value = "查询所有标签")
    @GetMapping("/customer/orderlabel/queryOrderLabel")
    @GogirlMember
    public JsonResult<List<OrderCommentLabel>> queryOrderLabel() {
        List<OrderCommentLabel> listOrderCommentLabel = orderCommentLabelMapper.selectList(new QueryWrapper<>());
        return JsonResult.success(listOrderCommentLabel);
    }
}
