package com.gogirl.interfaces.wxappmember.order.mall.facade.req;

import com.gogirl.domain.order.mall.MallOrder;
import com.gogirl.infrastructure.common.base.PageReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("订单列表查询参数")
public class ListMallOrderReqDTO extends PageReq {

    @ApiModelProperty("订单类型 1-订单待付款 2-订单已付款 3-订单已发货 4-订单已签收")
    private Integer status;


    public static MallOrder convertToMallOrder(ListMallOrderReqDTO reqDTO) {
        MallOrder mallOrder = new MallOrder();
        mallOrder.setStatus(reqDTO.getStatus());
        return mallOrder;
    }
}
