package com.gogirl.interfaces.wxappmember.market;

import com.gogirl.application.market.LeisureDiscountConfigService;
import com.gogirl.domain.market.discount.LeisureDiscountConfig;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api("闲时折扣")
@AllArgsConstructor
@Slf4j
public class LeisureConfigController {

    private final LeisureDiscountConfigService leisureDiscountConfigService;

    @ApiOperation("用户端-获取最小闲时折扣")
    @GetMapping("/customer/leisure/queryMinDiscount")
    public JsonResult<LeisureDiscountConfig> queryMinDiscount() {
        LeisureDiscountConfig config = leisureDiscountConfigService.queryMinDiscount();
        return JsonResult.success(config);
    }

}
