package com.gogirl.infrastructure.mapper.order.serve;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gogirl.domain.order.serve.OrderManage;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * Created by yinyong on 2018/9/21.
 */
@Mapper
@Repository
public interface OrderManageMapper extends BaseMapper<OrderManage> {


    OrderManage getAggregate(Integer id);

    double countSumPay(Integer customerId, Integer departmentId);

    int updateOrderDataIntegrity(OrderManage orderManage);

    Integer countOrderTimes(Integer customerId);

    /**
     * 获取今天最近的一个订单
     *
     * @return order
     */
    OrderManage latestOfDay();
}
