package com.gogirl.infrastructure.mapper.market;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gogirl.domain.market.serve.DiscountConfig;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface DiscountConfigMapper extends BaseMapper<DiscountConfig> {

    /**
     * 查询所有冲送折扣出了默认0送0
     *
     * @return config
     */
    List<DiscountConfig> selectAllDiscount();

    /**
     * 查询amount对应的冲送级别
     *
     * @param amount amount
     * @return
     */
    DiscountConfig selectByCharge(int amount);
}
