package com.gogirl.infrastructure.interceptor;

import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.exception.RRException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Component
@AllArgsConstructor
@Slf4j
public class LoginHandlerInterceptor implements HandlerInterceptor {

    private final GogirlTokenService gogirlTokenService;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

        String token = request.getHeader("token");

        if (request.getRequestURI().contains("no_")) {
            return true;
        }

        GogirlToken gogirlToken = gogirlTokenService.getTokenByToken(token);
        if (gogirlToken == null
                || gogirlToken.getCustomerId() == null
                || gogirlToken.getCustomer() == null) {
            log.error(request.toString());
            throw new RRException(2000, "token失效，请重新登陆");
        }
        return true;
    }
}
