package com.gogirl.infrastructure.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gogirl.infrastructure.interceptor.LogHandlerInterceptor;
import com.gogirl.infrastructure.interceptor.LoginHandlerInterceptor;
import lombok.AllArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

import java.text.SimpleDateFormat;

@Configuration
@AllArgsConstructor
public class MvcInterceptorConfig extends WebMvcConfigurationSupport {

    private final LoginHandlerInterceptor loginHandlerInterceptor;
    private final LogHandlerInterceptor logHandlerInterceptor;

    @Override
    protected void addInterceptors(InterceptorRegistry registry) {

        /*多个拦截器组成一个拦截器链*/
        /*addPathPatterns 用于添加拦截规则*/
        /* **表示拦截所有请求*/
        /*excludePathPatterns 用户排除拦截*/
        registry.addInterceptor(loginHandlerInterceptor).addPathPatterns("/**")
                .excludePathPatterns("/swagger-resources/**", "/webjars/**", "/v2/**", "/swagger-ui.html/**")
                //登陆
                .excludePathPatterns("/xcx/login")
                .excludePathPatterns("/csrf")
                .excludePathPatterns("/mallCategory/getCategoryTree")
                .excludePathPatterns("/mallCategory/getCategoryList")
                .excludePathPatterns("/mallProduct/queryPageProduct")
                .excludePathPatterns("/mallProduct/queryProduct")
                .excludePathPatterns("/serve/no_queryNewServePage")
                .excludePathPatterns("/serve/queryServeForPage")
                .excludePathPatterns("/broadcast/queryBroadcast")
                .excludePathPatterns("/shop/queryShopEnvironmentPhotos")
                //回调
                .excludePathPatterns("/pay/notifyTimesCard")
                .excludePathPatterns("/pay/notifyCharge")
                .excludePathPatterns("/mallOrderPay/notifyMallOrder")

                .excludePathPatterns("/xcx/authorized1")
                .excludePathPatterns("/xcx/authorizedPhone")
                .excludePathPatterns("/pay/notifyOrder")
                .excludePathPatterns("/pay/notifyBalanceWxPay")
//                .excludePathPatterns("/pay/balanceWxPay")

                //退款
                .excludePathPatterns("/mallOrderPay/refund/*")
                .excludePathPatterns("/xcx/upload");

        registry.addInterceptor(logHandlerInterceptor);

        super.addInterceptors(registry);
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {

        //swagger增加url映射
        registry.addResourceHandler("/swagger-ui.html")
                .addResourceLocations("classpath:/META-INF/resources/");

        registry.addResourceHandler("/webjars/**")
                .addResourceLocations("classpath:/META-INF/resources/webjars/");
    }

    /*定义时间格式转换器*/
    @Bean
    public MappingJackson2HttpMessageConverter jackson2HttpMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        converter.setObjectMapper(mapper);
        return converter;
    }

//    /*添加转换器*/
//    @Override
//    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
//        //将我们定义的时间格式转换器添加到转换器列表中,
//        //这样jackson格式化时候但凡遇到Date类型就会转换成我们定义的格式
//        converters.add(jackson2HttpMessageConverter());
//    }

}


