package com.gogirl.domain.user;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.util.Map;

@Data
@ApiModel("顾客消息")
@Builder
public class CustomerMessage {
    public static final Integer STATUS_UN_READ = 1;
    public static final Integer STATUS_READIED = 2;
    public static final Integer TYPE_FRIEND_PAY = 1;
    public static final Integer TYPE_FRIEND_SCHEDULE_PAY = 2;
    public static final String PARAM_FRIEND_PAY_ORDER_ID = "orderId";
    public static final String PARAM_FRIEND_PAY_CUSTOMER_ID = "customerId";
    private Long id;
    @ApiModelProperty("顾客id")
    private Integer customerId;
    @ApiModelProperty("消息标题")
    private String header;
    @ApiModelProperty("消息内容")
    private String body;
    @ApiModelProperty("1-商城订单代收款消息  2-预约订单代收款消息")
    private Integer type;
    @ApiModelProperty("1-未读 2-已读")
    private Integer status;
    @ApiModelProperty("消息携带参数")
    private String paramsJson;
    @TableField(exist = false)
    private Map<String, Object> params;

}
