package com.gogirl.domain.order.purchase;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 采购单
 * </p>
 *
 * @author luobin
 * @since 2019-11-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "PurchaseOrder对象", description = "采购单")
@TableName("purchase_order")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PurchaseOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "商品sku编号")
    private String sku;

    @ApiModelProperty(value = "没有关联sku前,店员填的商品名字")
    private String orderName;

    @ApiModelProperty(value = "订单创建人")
    private Integer creater;

    private String createrName;

    @ApiModelProperty(value = "该订单的采购单价")
    private BigDecimal price;

    @ApiModelProperty(value = "采购数量")
    private Integer quantity;

    @ApiModelProperty(value = "发起采购的店铺")
    private Integer createDepartmentId;

    @ApiModelProperty(value = "采购寄到哪个店铺id")
    private Integer departmentId;

    private String departmentName;

    @ApiModelProperty(value = "-1.作废 1.待采购;2.采购中;3.待入库;4.待出库;5.待收货;6.已完成;")
    private Integer status;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "待采购时间")
    private Date waitPurchaseTime;

    @ApiModelProperty(value = "确认采购时间")
    private Date purchaseTime;

    @ApiModelProperty(value = "入库时间")
    private Date inStoreTime;

    @ApiModelProperty(value = "出库时间")
    private Date outStoreTime;

    @ApiModelProperty(value = "收货时间")
    private Date receiveTime;

    @ApiModelProperty(value = "收货人id")
    private Integer receiver;

    @ApiModelProperty(value = "创建采购时的备注")
    private String createRemark;

    @ApiModelProperty(value = "收货时备注")
    private String receiveRemark;

    @ApiModelProperty(value = "1.入库;2.出库")
    private Integer stockType;

    private Integer stockNum;

    private String skuName;

    private String skuPicturePath;

    private String skuTypeName;

    private BigDecimal shopPrice;
}
