package com.gogirl.application.user.customer.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.user.customer.CustomerService;
import com.gogirl.domain.user.Customer;
import com.gogirl.infrastructure.mapper.user.CustomerMapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@AllArgsConstructor
@Slf4j
public class CustomerServiceImpl extends ServiceImpl<CustomerMapper, Customer> implements CustomerService {

    private final CustomerMapper customerMapper;

    @Override
    public Customer selectByPhone(String phone) {
        return customerMapper.selectByPhone(phone);
    }

    @Override
    public Customer selectByCustomerId(Integer scheduledUser) {
        return customerMapper.selectById(scheduledUser);
    }
}
