package com.gogirl.application.store.store.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.store.StoreTechnicianService;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.infrastructure.mapper.store.StoreTechnicianMapper;
import com.gogirl.infrastructure.mapper.store.UserTechnicianMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
@AllArgsConstructor
public class StoreTechnicianServiceImpl extends ServiceImpl<StoreTechnicianMapper, StoreTechnician> implements StoreTechnicianService {

    private final UserTechnicianMapper StoreTechnicianMapper;

    public StoreTechnician getTechnicianManageForDetail(Integer id) {
        return StoreTechnicianMapper.getTechnicianManageForDetail(id);
    }

    public List<StoreTechnician> listTechnicianForPage(StoreTechnician technicianManage) {
        return StoreTechnicianMapper.listTechnicianForPage(technicianManage);
    }

    public List<StoreTechnician> getTechnicianManageByOpenid(String openid) {
        return StoreTechnicianMapper.getTechnicianManageByOpenid(openid);
    }

    public void updateTechnicianByAuthorityId(StoreTechnician item) {
        StoreTechnicianMapper.updateTechnicianByAuthorityId(item);
    }

    public List<StoreTechnician> queryDayTechnicianClasses(Integer departmentId, Date day) {
        return StoreTechnicianMapper.queryDayTechnicianClasses(departmentId, day);
    }

}
