package com.gogirl.application.product.mall;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.product.mall.PurchaseSku;

/**
 * sku服务接口
 */
public interface PurchaseSkuService extends IService<PurchaseSku> {

    /**
     * 分页查询商城sku
     *
     * @param pageNum        页码
     * @param pageSize       每页记录数
     * @param mallCategoryId 分类Id
     * @return page
     */
    IPage<PurchaseSku> queryPagePurchaseSku(Integer pageNum, Integer pageSize, Long mallCategoryId);

    /**
     * 获取商品sku详情
     *
     * @param purchaseSkuId
     * @return aggre
     */
    PurchaseSku getPurchaseSku(Integer purchaseSkuId);
}
