package com.gogirl.application.order.serve.impl;

import com.gogirl.domain.order.serve.*;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.shared.order.serve.query.dto.ordermanage.*;
import lombok.AllArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.function.Function;
import java.util.stream.Collectors;

@Component
@AllArgsConstructor
public class OrderManageDTOAssembler implements Function<OrderManage, OrderManageDTO> {


    private final OrderServeDTOAssembler orderServeDTOAssembler;

    @Override
    public OrderManageDTO apply(OrderManage orderManage) {
        OrderManageDTO orderManageDTO = new OrderManageDTO();
        BeanUtils.copyProperties(orderManage, orderManageDTO);
        orderManageDTO.setOrderServeDTOList(
                orderManage.getListOrderServer()
                        .stream()
                        .map(orderServeDTOAssembler)
                        .collect(Collectors.toList())
        );

        return orderManageDTO;
    }

    @Component
    @AllArgsConstructor
    static class OrderServeDTOAssembler implements Function<OrderServe, OrderServeDTO> {

        private final OrderServeSkuDTOAssembler orderServeSkuDTOAssembler;
        private final OrderRecordDTOAssembler orderRecordDTOAssembler;
        private final OrderServeDescribeDTOAssembler orderServeDescribeDTOAssembler;

        @Override
        public OrderServeDTO apply(OrderServe orderServe) {
            OrderServeDTO orderServeDTO = new OrderServeDTO();
            BeanUtils.copyProperties(orderServe, orderServeDTO);

            if (orderServe.getOrderRecord() != null) {
                orderServeDTO.setOrderRecordDTO(orderRecordDTOAssembler.apply(orderServe.getOrderRecord()));
            }

            if (ListUtil.isNotEmpty(orderServeDTO.getOrderServeDescribeDTOList())) {
                orderServeDTO.setOrderServeDescribeDTOList(orderServe
                        .getListOrderServeDescribe()
                        .stream().map(orderServeDescribeDTOAssembler)
                        .collect(Collectors.toList()));
            }

            if (ListUtil.isNotEmpty(orderServe.getListOrderServeSku())) {
                orderServeDTO.setOrderServeSkuDTOList(orderServe.getListOrderServeSku()
                        .stream()
                        .map(orderServeSkuDTOAssembler)
                        .collect(Collectors.toList()));
            }

            orderServeDTO.setTechnicianIds(orderServe.getTechnicianId());
            orderServeDTO.setTechnicianNames(orderServe.getTechnicianName());
            return orderServeDTO;
        }


        @Component
        static class OrderServeSkuDTOAssembler implements Function<OrderServeSku, OrderServeSkuDTO> {

            @Override
            public OrderServeSkuDTO apply(OrderServeSku orderServeSku) {
                OrderServeSkuDTO orderServeSkuDTO = new OrderServeSkuDTO();
                BeanUtils.copyProperties(orderServeSku, orderServeSkuDTO);
                return orderServeSkuDTO;
            }
        }

        @Component
        static class OrderRecordDTOAssembler implements Function<OrderRecord, OrderRecordDTO> {

            @Override
            public OrderRecordDTO apply(OrderRecord orderRecord) {
                OrderRecordDTO orderRecordDTO = new OrderRecordDTO();
                BeanUtils.copyProperties(orderRecord, orderRecordDTO);
                return orderRecordDTO;
            }
        }

        @Component
        static class OrderServeDescribeDTOAssembler implements Function<OrderServeDescribe, OrderServeDescribeDTO> {

            @Override
            public OrderServeDescribeDTO apply(OrderServeDescribe orderServeDescribe) {
                OrderServeDescribeDTO orderServeDescribeDTO = new OrderServeDescribeDTO();
                BeanUtils.copyProperties(orderServeDescribe, orderServeDescribeDTO);
                return orderServeDescribeDTO;
            }
        }


    }

}
