package com.gogirl.application.order.serve;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.order.serve.ScheduleManage;
import com.gogirl.domain.order.serve.ScheduleServe;
import com.gogirl.interfaces.wxappmember.order.serve.facade.IdleTimeProgramQuery;
import com.gogirl.shared.order.serve.command.schedule.CancelScheduleCommand;
import com.gogirl.shared.order.serve.command.schedule.SubmitScheduleCommand;
import com.gogirl.shared.order.serve.command.schedule.UpdateScheduleCommand;
import com.gogirl.shared.order.serve.query.dto.IdleTimeDTO;
import com.gogirl.shared.order.serve.query.qry.schedule.ScheduleManagePageQuery;
import com.gogirl.shared.order.serve.query.qry.schedule.ScheduleManageQuery;

import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * 预约service
 */
public interface ScheduleManageService extends IService<ScheduleManage> {


    /**
     * 普通预约入口查询预约时间
     *
     * @param param param
     * @return list
     * @throws ParseException exception
     */
    List<IdleTimeDTO> queryIdleTime(IdleTimeProgramQuery param) throws ParseException;

    /**
     * 闲时入口查询预约时间
     *
     * @param departmentId 店铺id
     * @param scheduleDate 预约时间
     * @return list
     * @throws ParseException exception
     */
    List<IdleTimeDTO> queryLeisureTime(Integer departmentId, String scheduleDate) throws ParseException;

    /**
     * 取消预约
     *
     * @param cmd
     */
    void cancelSchedule(CancelScheduleCommand cmd);


    /**
     * 不知道
     *
     * @param startDateTime 开始时间
     * @param endDateTime   结束时间
     * @param departmentId  店铺id
     * @param orderId       订单id
     * @return list
     */
    List<ScheduleServe> listScheduleServeNotContainOrderId(String startDateTime, String endDateTime, Integer departmentId, Integer orderId);//xcx


    /**
     * 更新预约时间
     *
     * @param scheduleServeId
     * @param status
     */
    void updateScheduledServeStatus(Integer scheduleServeId, Integer status);


    /**
     * 美甲师接单前检查预约
     *
     * @param technicianId
     * @param scheduleId
     */
    void checkBeforeTakeOrders(Integer technicianId, Integer scheduleId);

    /**
     * 提交预约
     *
     * @param cmd 提交预约命令
     */
    void submitSchedule(SubmitScheduleCommand cmd);

    /**
     * 更新预约
     *
     * @param cmd
     * @return
     */
    void updateSchedule(UpdateScheduleCommand cmd);

    /**
     * 更新预约前检查
     *
     * @param cmd
     */
    void checkBeforeUpdate(UpdateScheduleCommand cmd);


    /**
     * 店员获取时间列表
     *
     * @param startDate
     * @param lengthTime
     * @param departmentId
     * @param orderId
     * @param needRemoveOldServe
     * @return
     */
    List<Map<String, Object>> queryReservableTime(String startDate, Integer lengthTime, Integer departmentId, Integer orderId, Boolean needRemoveOldServe);

    ScheduleManage queryScheduleManage(ScheduleManageQuery qry);

    IPage<ScheduleManage> queryPageScheduleManage(ScheduleManagePageQuery qry);
}
