package com.gogirl.application.order.mall;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.gogirl.domain.order.mall.MallRefundOrder;
import com.gogirl.interfaces.wxappmember.order.mall.facade.RefundOrderByDetailIdRequest;

public interface MallRefundOrderService extends IService<MallRefundOrder> {

    /**
     * 申请退款
     *
     * @param mallRefundOrder
     */
    void refundOrder(MallRefundOrder mallRefundOrder);

    /**
     * 保存退款订单聚合对象
     *
     * @param mallRefundOrder
     */
    void saveAggregate(MallRefundOrder mallRefundOrder);


    /**
     * 退款
     *
     * @param orderDetailId
     */
    void refund(Long orderDetailId) throws WxPayException;

    /**
     * 针对单项退款
     *
     * @param request
     */
    void refundOrderByDetailId(RefundOrderByDetailIdRequest request);
}
