package com.gogirl.application.market.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.market.CouponService;
import com.gogirl.domain.market.serve.Coupon;
import com.gogirl.domain.market.serve.CouponCustomerRelevance;
import com.gogirl.infrastructure.mapper.market.CouponCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.market.CouponMapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
@AllArgsConstructor
@Slf4j
public class CouponServiceImpl extends ServiceImpl<CouponMapper, Coupon> implements CouponService {

    private final CouponMapper couponMapper;
    private final CouponCustomerRelevanceMapper couponCustomerRelevanceDao;


    @Override
    public List<CouponCustomerRelevance> selectMyCoupon(Integer customerId) {
        return couponCustomerRelevanceDao.selectMyCoupon(customerId);
    }

    @Override
    public int countRelevanceNum(CouponCustomerRelevance record) {
        return couponCustomerRelevanceDao.countRelevanceNum(record);
    }

    @Override
    public int insertSelective(Coupon coupon, CouponCustomerRelevance record) {
        if (record.getState() == null) {
            record.setState(1);
        }
        if (record.getCode() == null) {
            record.setCode(getRandomCode());
        }
        if (record.getReceiveTime() == null) {
            record.setReceiveTime(new Date());
        }
        if ((record.getValidStartTime() == null || record.getValidEndTime() == null) && coupon != null) {
            if (coupon.getValidType() == 1) {
                record.setValidStartTime(coupon.getValidStartTime());//优惠券原有开始和结束时间
                record.setValidEndTime(coupon.getValidEndTime());
            } else if (coupon.getValidType() == 2) {
                long today = new Date().getTime();
                long day7 = today + 86400000L * coupon.getValidDate();
                record.setValidStartTime(new Date(today));//从现在开始
                record.setValidEndTime(new Date(day7));//七天后过期
            }
        }

        //修改已领取人数
        Coupon c = couponMapper.selectById(record.getCouponId());
        Coupon changeQuantity = new Coupon();
        changeQuantity.setId(record.getCouponId());
        changeQuantity.setReceiveQuantity(c.getReceiveQuantity() + 1);
        couponMapper.updateByPrimaryKeySelective(changeQuantity);


        couponCustomerRelevanceDao.insert(record);
        return record.getId();
    }

    @Override
    public String getRandomCode() {
        String code = couponCustomerRelevanceDao.getRandomCode(Math.random());
        if (code != null) {
            couponCustomerRelevanceDao.deleteCode(code);
        }
        return code;
    }


    @Override
    public List<CouponCustomerRelevance> selectMyNewCustomerCoupon(Integer customerId, List<Integer> couponIdList) {
        return couponCustomerRelevanceDao.selectMyNewCustomerCoupon(customerId, couponIdList);
    }

}
