package com.gogirl.application.market;

import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.market.serve.Coupon;
import com.gogirl.domain.market.serve.CouponCustomerRelevance;

import java.util.List;


public interface CouponService extends IService<Coupon> {


    /**
     * 查询我的卡券
     *
     * @param customerId 会员id
     * @return 卡券列表
     */
    List<CouponCustomerRelevance> selectMyCoupon(Integer customerId);


    /**
     * 获取统一卡券领取的张数
     *
     * @param record param
     * @return count
     */
    int countRelevanceNum(CouponCustomerRelevance record);


    /**
     * 给用户发券 并且修改卡券已领取人数
     *
     * @param coupon 卡券类型
     * @param record 卡券实体
     * @return true
     */
    int insertSelective(Coupon coupon, CouponCustomerRelevance record);


    /**
     * 获取卡券随机数 不知道什么用
     *
     * @return
     */
    String getRandomCode();


    /**
     * 查询是否领过对应卡券
     *
     * @param customerId   用户id
     * @param couponIdList 卡券类型id
     * @return
     */
    List<CouponCustomerRelevance> selectMyNewCustomerCoupon(Integer customerId, List<Integer> couponIdList);

}
