//package com.gogirl.application.order.mall.impl;
//
//import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
//import com.gogirl.application.order.mall.MallCustomerAddressService;
//import com.gogirl.application.order.mall.MallOrderCmdService;
//import com.gogirl.application.order.mall.MallOrderService;
//import com.gogirl.application.order.mall.MallShoppingCartService;
//import com.gogirl.domain.order.mall.*;
//import com.gogirl.infrastructure.common.exception.RRException;
//import com.gogirl.shared.market.SubmitMallOrderCommand;
//import com.gogirl.shared.member.ImmediatePurchaseCommand;
//import com.gogirl.shared.order.CancelMallOrderCommand;
//import com.gogirl.shared.order.MallOrderDTO;
//import com.gogirl.shared.order.SettleMallOrderItemQuery;
//import com.gogirl.shared.order.SettleMallOrderQuery;
//import com.gogirl.infrastructure.common.util.SpringBeanUtils;
//import com.google.common.collect.Lists;
//import io.seata.spring.annotation.GlobalTransactional;
//import lombok.AllArgsConstructor;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.BeanUtils;
//import org.springframework.stereotype.Service;
//
//import java.math.BigDecimal;
//import java.util.List;
//import java.util.stream.Collectors;
//
////import com.gogirl.infrastructure.feign.order.mall.ProductMallOrderControllerFeign;
//
//@Service
//@AllArgsConstructor
//@Slf4j
//public class MallOrderCmdServiceImpl implements MallOrderCmdService {
//
//
//    /**
//     * domain service
//     */
//    private final MallShoppingCartService mallShoppingCartService;
//    private final MallCustomerAddressService mallCustomerAddressService;
//    private final MallOrderService mallOrderService;
//
//    @GlobalTransactional(name = "gogirl-tx-group", rollbackFor = Exception.class)
//    @Override
//    public void submitMallOrder(SubmitMallOrderCommand cmd) {
//        long time = System.currentTimeMillis();
//        log.info("用户{}下单，时间{}", cmd.getCustomerId(), time);
//
//
//        List<MallShoppingCart> mallShoppingCartList = mallShoppingCartService.list(new LambdaQueryWrapper<MallShoppingCart>().in(MallShoppingCart::getId, cmd.getMallShoppingCartIdList()));
//
//        if (mallShoppingCartList.size() != cmd.getMallShoppingCartIdList().size()) {
//            throw new RRException(500, "请重新检查购物车");
//        }
//
//        //清除购物车项
//        mallShoppingCartService.remove(new LambdaQueryWrapper<MallShoppingCart>().in(MallShoppingCart::getId, cmd.getMallShoppingCartIdList()));
//
//
//        //产品服务获取结算订单
//        List<SettleMallOrderItemQuery> settleMallOrderItemQryList = mallShoppingCartList.stream()
//                .map(mallShoppingCart -> {
//                    SettleMallOrderItemQuery settleMallOrderItemQry = new SettleMallOrderItemQuery();
//                    settleMallOrderItemQry.setNum(mallShoppingCart.getNum());
//                    settleMallOrderItemQry.setProductId(mallShoppingCart.getProductId());
//                    return settleMallOrderItemQry;
//                })
//                .collect(Collectors.toList());
//
//        SettleMallOrderQuery settleMallOrderQry = new SettleMallOrderQuery(cmd.getCustomerId(), settleMallOrderItemQryList);
//        log.info("获取产品服务结算订单开始 param:{}", settleMallOrderQry);
//        MallOrderDTO mallOrderDTO = mallOrderService.querySettleMalOrder(settleMallOrderQry);
//        log.info("获取产品服务结算订单结束 mallOrderDTO:{}", mallOrderDTO);
//
//        MallOrder mallOrder = new MallOrder();
//
//        //订单参数
//        SpringBeanUtils.copyPropertiesIgnoreNull(cmd, mallOrder);
//        //结算订单参数
//        SpringBeanUtils.copyPropertiesIgnoreNull(mallOrderDTO, mallOrder);
//
//        //结算订单详情参数
//        mallOrder.setMallOrderDetailList(mallOrderDTO
//                .getMallOrderDetailDTOList()
//                .stream()
//                .map(mallOrderDetailDTO -> {
//                    MallOrderDetail mallOrderDetail = new MallOrderDetail();
//                    BeanUtils.copyProperties(mallOrderDetailDTO, mallOrderDetail);
//                    return mallOrderDetail;
//                })
//                .collect(Collectors.toList()));
//
//        mallOrder.setCustomerId(cmd.getCustomerId());
//
//        //订单状态
//        mallOrder.setStatus(MallOrder.STATUS_UN_PAY);
//
//        //时间
//        mallOrder.setCreateTime(System.currentTimeMillis());
//        //下单时间
//        mallOrder.setOrderTime(System.currentTimeMillis());
//
//        //交易方式 线上交易
//        mallOrder.setTransactionType(MallOrder.TRANSACTION_TYPE_ONLINE);
//
//        if (mallOrder.getTransportMode().equals(1)) {
//            //设置运费
//            mallOrder.setFreight(mallOrder.getTotalAmount().compareTo(new BigDecimal(100)) > 0 ? new BigDecimal(0.00) : new BigDecimal(6.00));
//        } else {
//            mallOrder.setFreight(BigDecimal.ZERO);
//        }
//
//        mallOrder.setTotalPayAmount(mallOrder.getTotalAmount().add(mallOrder.getFreight()));
//        //收货地址
//        MallCustomerAddress mallCustomerAddress = mallCustomerAddressService.getById(cmd.getMallCustomerAddressId());
//        MallOrderAddress mallOrderAddress = new MallOrderAddress();
//        if (mallCustomerAddress != null) {
//            BeanUtils.copyProperties(mallCustomerAddress, mallOrderAddress, "id");
//            mallOrderAddress.setName(mallCustomerAddress.getCustomerName());
//            mallOrderAddress.setPhone(mallCustomerAddress.getPhone());
//            mallOrder.setMallOrderAddress(mallOrderAddress);
//        }
//
//        //保存订单聚合
//        mallOrderService.saveAggregate(mallOrder);
//
//        //设置命令结果
//        cmd.setExecutionResult(mallOrder.getId());
//        log.info("用户{}下单结束，时间{},耗时{}", cmd.getCustomerId(), System.currentTimeMillis(), System.currentTimeMillis() - time);
//
//    }
//
//    @Override
//    public void cancelMallOrder(CancelMallOrderCommand cmd) {
//        mallOrderControllerFeign.cancelMallOrder(cmd);
//    }
//
//    @Override
//    public void immediatePurchase(ImmediatePurchaseCommand cmd) {
//
//        long time = System.currentTimeMillis();
//        log.info("用户{}下单，时间{}", cmd.getCustomerId(), time);
//
//        //产品服务获取结算订单
//        List<SettleMallOrderItemQuery> settleMallOrderItemQryList = Lists.newArrayList(
//                new SettleMallOrderItemQuery(cmd.getProductId(), cmd.getNum())
//        );
//
//        SettleMallOrderQuery settleMallOrderQry = new SettleMallOrderQuery(cmd.getCustomerId(), settleMallOrderItemQryList);
//
//        log.info("获取产品服务结算订单开始 param:{}", settleMallOrderQry);
//        MallOrderDTO mallOrderDTO = productMallOrderControllerFeign.settleMallOrder(settleMallOrderQry).getData();
//        log.info("获取产品服务结算订单结束 mallOrderDTO:{}", mallOrderDTO);
//
//        MallOrder mallOrder = new MallOrder();
//
//        //订单参数
//        SpringBeanUtils.copyPropertiesIgnoreNull(cmd, mallOrder);
//        //结算订单参数
//        SpringBeanUtils.copyPropertiesIgnoreNull(mallOrderDTO, mallOrder);
//
//        //结算订单详情参数
//        mallOrder.setMallOrderDetailList(mallOrderDTO
//                .getMallOrderDetailDTOList()
//                .stream()
//                .map(mallOrderDetailDTO -> {
//                    MallOrderDetail mallOrderDetail = new MallOrderDetail();
//                    BeanUtils.copyProperties(mallOrderDetailDTO, mallOrderDetail);
//                    return mallOrderDetail;
//                })
//                .collect(Collectors.toList()));
//
//        mallOrder.setCustomerId(cmd.getCustomerId());
//
//        //订单状态
//        mallOrder.setStatus(MallOrder.STATUS_UN_PAY);
//
//        //时间
//        mallOrder.setCreateTime(System.currentTimeMillis());
//        mallOrder.setOrderTime(System.currentTimeMillis());
//
//        //交易方式 线上交易
//        mallOrder.setTransactionType(MallOrder.TRANSACTION_TYPE_ONLINE);
//
//        //收货地址
//        MallCustomerAddress mallCustomerAddress = mallCustomerAddressService.getById(cmd.getMallCustomerAddressId());
//        MallOrderAddress mallOrderAddress = new MallOrderAddress();
//        if (mallCustomerAddress != null) {
//            BeanUtils.copyProperties(mallCustomerAddress, mallOrderAddress, "id");
//            mallOrderAddress.setName(mallCustomerAddress.getCustomerName());
//            mallOrderAddress.setPhone(mallCustomerAddress.getPhone());
//            mallOrder.setMallOrderAddress(mallOrderAddress);
//        }
//
//        //保存订单聚合
//        mallOrderService.saveAggregate(mallOrder);
//
//        //设置命令结果
//        cmd.setExecutionResult(mallOrder.getId());
//        log.info("用户{}下单结束，时间{},耗时{}", cmd.getCustomerId(), System.currentTimeMillis(), System.currentTimeMillis() - time);
//
//
//    }
//}
