package com.gogirl.interfaces.product.serve;


import com.gogirl.application.product.serve.IColorSystemService;
import com.gogirl.domain.product.serve.ColorSystem;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 色系 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-03-09
 */
@RestController
@AllArgsConstructor
public class ColorSystemController {

    private final IColorSystemService colorSystemService;

    @ApiOperation("查询所有款式色系")
    @GetMapping("/customer/colorSystem/no_query")
    public JsonResult<List<ColorSystem>> query() {
        List<ColorSystem> list = colorSystemService.list();
        return JsonResult.success(list);
    }

}
