package com.gogirl.application.order.mall.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.order.mall.MallCustomerAddressService;
import com.gogirl.domain.order.mall.MallCustomerAddress;
import com.gogirl.infrastructure.mapper.order.mall.MallCustomerAddressMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class MallCustomerAddressServiceImpl extends ServiceImpl<MallCustomerAddressMapper, MallCustomerAddress> implements MallCustomerAddressService {

    @Override
    public void addMallCustomerAddress(MallCustomerAddress mallCustomerAddress) {
        this.save(mallCustomerAddress);
    }

    @Override
    public MallCustomerAddress getDefaultMallCustomerAddress(Integer currentCustomerId) {

        List<MallCustomerAddress> mallCustomerAddressList = this.list(
                new LambdaQueryWrapper<MallCustomerAddress>()
                        .eq(MallCustomerAddress::getCustomerId, currentCustomerId)
        );


        return mallCustomerAddressList.stream()
                .filter(mallCustomerAddress -> mallCustomerAddress.getIsDefault().equals(MallCustomerAddress.IS_DEFAULT_TRUE))
                .findAny()
                .orElse(mallCustomerAddressList
                        .stream()
                        .findAny()
                        .orElse(null));
    }

    @Transactional(timeout = 10000)
    @Override
    public MallCustomerAddress updateDefaultMallCustomerAddress(Integer currentCustomerId, Long mallCustomerAddressId) {
        MallCustomerAddress defaultMallCustomerAddress = this.getOne(
                new LambdaQueryWrapper<MallCustomerAddress>()
                        .eq(MallCustomerAddress::getCustomerId, currentCustomerId)
                        .eq(MallCustomerAddress::getIsDefault, MallCustomerAddress.IS_DEFAULT_TRUE)
        );
        defaultMallCustomerAddress.setIsDefault(MallCustomerAddress.IS_DEFAULT_FALSE);
        this.updateById(defaultMallCustomerAddress);


        MallCustomerAddress mallCustomerAddress = this.getOne(
                new LambdaQueryWrapper<MallCustomerAddress>()
                        .eq(MallCustomerAddress::getCustomerId, currentCustomerId)
                        .eq(MallCustomerAddress::getId, mallCustomerAddressId)
        );

        mallCustomerAddress.setIsDefault(MallCustomerAddress.IS_DEFAULT_TRUE);
        this.updateById(mallCustomerAddress);

        return defaultMallCustomerAddress;
    }

    @Override
    public List<MallCustomerAddress> listMallCustomerAddress(Integer currentCustomerId) {
        return this.list(
                new LambdaQueryWrapper<MallCustomerAddress>()
                        .eq(MallCustomerAddress::getCustomerId, currentCustomerId)
        );
    }

    @Override
    public void changeMallCustomerAddress(MallCustomerAddress mallCustomerAddress) {
        mallCustomerAddress.setIsDefault(null);
        this.updateById(mallCustomerAddress);
    }
}
