package com.gogirl.shared.product;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class MallProductDTO {

    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    private String productSku;

    @ApiModelProperty("商品名称")
    private String name;

    @ApiModelProperty("商品副标题")
    private String subTitle;

    @ApiModelProperty("商品封面图")
    private String coverImages;

    @ApiModelProperty("商品头图，逗号分隔")
    private String headImages;

    @ApiModelProperty("商品详情图，逗号分隔")
    private String detailImages;

    @ApiModelProperty("颜色，逗号分隔")
    private String color;

    @ApiModelProperty("商品价格")
    private BigDecimal price;

    @ApiModelProperty("原产地")
    private String originPlace;

    @ApiModelProperty("原产地")
    private String shelfLife;

    @ApiModelProperty("成分")
    private String ingredient;

    @ApiModelProperty("商品描述")
    private String description;

    @ApiModelProperty("商品规格")
    private String specification;

    @ApiModelProperty("规格单位")
    private String unit;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("重量")
    private String weight;

    @ApiModelProperty("物流说明")
    private String courierInfo;

    @ApiModelProperty("保障说明")
    private String guaranteeInfo;

    @ApiModelProperty("售后说明")
    private String afterSaleInfo;

    @ApiModelProperty("详情视频")
    private String detailVideo;

    @ApiModelProperty("是否热卖 1-是 2-否")
    private Integer isHot;

    @ApiModelProperty("1-已上架 ，2-已下架")
    private Integer status;

    private Date createTime;

    @ApiModelProperty("系列id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long pId;

    private String colorNo;

    private String parentId;

    private Date updateTime;

    @ApiModelProperty("会员价")
    private BigDecimal memberPrice;

    @ApiModelProperty("特价")
    private BigDecimal bargainPrice;

    @ApiModelProperty("是否开启特价 1-是 2否")
    private Integer isBargainPrice;

    @ApiModelProperty("同系列产品")
    private List<MallProductDTO> serialProductList;

    private PurchaseSkuDTO purchaseSkuDTO;

    private String categoryName;

    private String serialCategoryName;

    private String modelName;

    @ApiModelProperty("首页标题")
    private String indexTitle;


}
