package com.gogirl.assembler;

import com.gogirl.domain.store.oa.TakeLeaveEvent;
import com.gogirl.shared.store.ApplyTakeLeaveCommand;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.function.Function;

@Component
public class ApplyTakeLeaveCommandAssembler implements Function<ApplyTakeLeaveCommand, TakeLeaveEvent> {

    @Override
    public TakeLeaveEvent apply(ApplyTakeLeaveCommand applyTakeLeaveCommand) {
        TakeLeaveEvent takeLeaveEvent = new TakeLeaveEvent();
        BeanUtils.copyProperties(applyTakeLeaveCommand, takeLeaveEvent);
        takeLeaveEvent.setStartTime(applyTakeLeaveCommand.getStartTime().getTime());
        takeLeaveEvent.setEndTime(applyTakeLeaveCommand.getEndTime().getTime());

        takeLeaveEvent.setTimeLength(applyTakeLeaveCommand.getTimeLength());

        return takeLeaveEvent;
    }
}
