package com.gogirl.application.product.serve.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.serve.ITechniqueSkuService;
import com.gogirl.domain.order.serve.ScheduleServe;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.product.serve.TechniqueCategory;
import com.gogirl.domain.product.serve.TechniqueSku;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.mapper.order.serve.ScheduleServeMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseServeMapper;
import com.gogirl.infrastructure.mapper.product.serve.TechniqueCategoryMapper;
import com.gogirl.infrastructure.mapper.product.serve.TechniqueSkuMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 技法sku 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-05-27
 */
@Service
public class TechniqueSkuServiceImpl extends ServiceImpl<TechniqueSkuMapper, TechniqueSku> implements ITechniqueSkuService {

    @Resource
    TechniqueSkuMapper techniqueSkuMapper;
    @Resource
    TechniqueCategoryMapper techniqueCategoryMapper;

    @Override
    public List<TechniqueSku> queryAll() {

        return techniqueSkuMapper.queryAll();
    }

    @Override
    public Map<String, List<TechniqueSku>> queryTechniqueSkuMap() {

        List<TechniqueSku> techniqueSkuList = this.list();
        List<TechniqueCategory> techniqueCategoryList = techniqueCategoryMapper.selectList(new LambdaQueryWrapper<>());

        Map<Integer, List<TechniqueSku>> integerListMap = techniqueSkuList.stream().collect(Collectors.groupingBy(TechniqueSku::getTechniqueCategoryId));

        Map<String, List<TechniqueSku>> result = new HashMap<>();
        techniqueCategoryList.forEach(techniqueCategory -> {
            result.put(JsonUtilByFsJson.beanToJson(techniqueCategory), integerListMap.get(techniqueCategory.getId()));
        });
        return result;
    }

    @Resource
    ScheduleServeMapper scheduleServeMapper;
    @Resource
    BaseServeMapper baseServeMapper;

    private final String TECH_REMOVE_ARMOR = "卸甲";
    private final String TECH_EXTEND = "光疗延长";


    @Override
    public List<TechniqueCategory> queryTechniqueCategoryAggregate(Integer scheduleServeId) {
        List<TechniqueSku> techniqueSkuList = this.list();
        LambdaQueryWrapper<TechniqueCategory> wrapper = new LambdaQueryWrapper<>();

        if (scheduleServeId != null) {
            ScheduleServe scheduleServe = scheduleServeMapper.selectById(scheduleServeId);
            BaseServe baseServe = baseServeMapper.selectById(scheduleServe.getServeId());

            ScheduleServe subRemoveArmor = scheduleServeMapper.subRemoveArmor(scheduleServeId, scheduleServe.getSchId());
            ScheduleServe subExtend = scheduleServeMapper.subExtend(scheduleServeId, scheduleServe.getSchId());

            wrapper.eq(TechniqueCategory::getServiceTypeId, baseServe.getTypeId());

            if (subRemoveArmor != null) {
                wrapper.ne(TechniqueCategory::getName, TECH_REMOVE_ARMOR);
            }
            if (subExtend != null) {
                wrapper.ne(TechniqueCategory::getName, TECH_EXTEND);
            }
        }

        List<TechniqueCategory> techniqueCategoryList = techniqueCategoryMapper.selectList(wrapper);
        Map<Integer, List<TechniqueSku>> integerListMap = techniqueSkuList.stream().collect(Collectors.groupingBy(TechniqueSku::getTechniqueCategoryId));

        techniqueCategoryList.forEach(techniqueCategory -> {
            techniqueCategory.setTechniqueSkuList(integerListMap.get(techniqueCategory.getId()));
        });
        return techniqueCategoryList;
    }
}
