package com.gogirl.shared.product.query.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class BaseServeDTO {

    private Integer id;

    @ApiModelProperty("服务名称")
    private String name;

    @ApiModelProperty("图片名称")
    private String picturePath;

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("标签")
    //todo
    private String label;

    @ApiModelProperty("服务价格")
    private BigDecimal price;

    @ApiModelProperty("排序")
    private Integer shopSort;

    @ApiModelProperty("状态 0：下架 1：上架 4：删除',")
    private Integer status;

    private String remark;

    @ApiModelProperty("详情")
    private String details;

    @ApiModelProperty("服务时长")
    private Integer serviceDuration;

    @ApiModelProperty("是否首页显示 1-是 ")
    private Integer hasIndexShow;

    @ApiModelProperty("首页排序")
    private Integer indexSort;

    @ApiModelProperty("//用户查询列表时，查用户是否点赞")
    private Integer cusId;

    @ApiModelProperty("用户点赞总数")
    private Integer praiseSum;

    @ApiModelProperty("服务简介")
    private String briefIntroduction;

    @ApiModelProperty("类型id")
    //todo
    private Integer typeId;


    @ApiModelProperty("预约分类")
    private Integer schTypeId;

    private String explain;

    private Integer serveLabelId;


    private BaseTypeDTO baseTypeDTO;

    /**
     * 非数据库字段
     */
    @ApiModelProperty("款式列表")
    private List<BaseProduceDTO> baseProduceDTOList;

}
