package com.gogirl.interfaces.xcx;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.store.oa.TakeLeaveEvent;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.domain.xcx.Message;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.mapper.xcx.MessageMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/message")
@Api(tags = {"10.美甲师消息和用户登入登出记录"}, value = "美甲师消息和用户登入登出记录")
@AllArgsConstructor
@Slf4j
public class TechnicianMessageController {

    private final MessageMapper messageMapper;
    private final GogirlTokenService gogirlTokenService;

    @ApiOperation(value = "获取我的消息")
    @PostMapping(value = "/technician/message/selectMyMessage")
    public JsonResult<Page<Message>> selectMyMessage(@RequestHeader String token,
                                                     Integer pageSize,
                                                     Integer pageNum,
                                                     Integer type,
                                                     Integer tab) {

        GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
        IPage<Message> page = new Page<>(pageNum, pageSize);
        StoreTechnician storeTechnician = SessionUtils.getStoreTechnician();
        page = messageMapper.selectMyMessage(page, storeTechnician.getId(), type, tab);
        page.getRecords().forEach(val -> {
            if (val.getType() == 1 || val.getType() == 3)
                val.setTakeLeaveEvent(JsonUtilByFsJson.jsonToBean(val.getParamJson(), TakeLeaveEvent.class));
        });
        return JsonResult.success((Page<Message>) page);
    }


    @ApiOperation(value = "我的消息管理")
    @PostMapping(value = "/technician/message/myMessageManage")
    public JsonResult<List<Message>> myMessageManage(@RequestHeader String token,
                                                     Integer pageSize,
                                                     Integer pageNum,
                                                     Integer tab) {


        StoreTechnician storeTechnician = SessionUtils.getStoreTechnician();
        List<Message> list = messageMapper.myMessageManage(storeTechnician.getId(), tab);
        list.forEach(message -> {
            Integer unread = messageMapper.selectUnReadCount(message.getTechnicianId(), message.getType());
            message.setUnread(unread);
        });

        return JsonResult.success(list);
    }

    @ApiOperation(value = "阅读消息")
    @GetMapping(value = "/technician/message/readMessage")
    public JsonResult<Void> readMessage(@RequestParam Integer id) {
        Message message = messageMapper.selectById(id);
        message.setIsRead(1);
        messageMapper.updateById(message);
        return JsonResult.success();
    }

}
