package com.gogirl.interfaces.product.serve;

import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.mapper.product.fetures.BaseFeaturesMapper;
import com.gogirl.shared.product.query.dto.ProduceLabelDTO;
import com.gogirl.shared.product.query.dto.ServeLabelDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

@RestController
@AllArgsConstructor
@Api("首页标签接口")
public class LabelController {

    private final BaseFeaturesMapper baseFeaturesMapper;

    @ApiOperation("查询首页服务标签")
    @GetMapping("/customer/label/no_queryServeLabel")
    public JsonResult<List<ServeLabelDTO>> queryServeLabel(@RequestParam(required = false) Integer typeId) {

        List<ServeLabelDTO> list = baseFeaturesMapper.queryServeFeatures(typeId)
                .stream()
                .map(baseFeatures -> {
                    ServeLabelDTO serveLabelDTO = new ServeLabelDTO();
                    serveLabelDTO.setId(baseFeatures.getId());
                    serveLabelDTO.setLabelEnName(baseFeatures.getEnName());
                    serveLabelDTO.setLabelName(baseFeatures.getName());
                    serveLabelDTO.setPicturePath(baseFeatures.getPicturePath());
                    return serveLabelDTO;
                })
                .collect(Collectors.toList());

        return JsonResult.success(list);
    }


    @ApiOperation("查询首页款式标签")
    @GetMapping("/customer/label/no_queryProduceLabel")
    public JsonResult<List<ProduceLabelDTO>> queryProduceLabel() {
        List<ProduceLabelDTO> list = baseFeaturesMapper.queryProduceFeatures()
                .stream()
                .map(baseFeatures -> {
                    ProduceLabelDTO produceLabelDTO = new ProduceLabelDTO();
                    produceLabelDTO.setId(baseFeatures.getId());
                    produceLabelDTO.setLabelEnName(baseFeatures.getEnName());
                    produceLabelDTO.setLabelName(baseFeatures.getName());
                    produceLabelDTO.setPicturePath(baseFeatures.getPicturePath());
                    return produceLabelDTO;
                })
                .collect(Collectors.toList());
        return JsonResult.success(list);
    }

}
