package com.gogirl.application.order.serve.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.gogirl.application.market.MarketService;
import com.gogirl.application.order.serve.OrderManageService;
import com.gogirl.application.order.serve.PayService;
import com.gogirl.application.user.customer.CustomerBalanceService;
import com.gogirl.domain.market.serve.DiscountConfig;
import com.gogirl.domain.order.serve.MultiPaymentType;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.user.Customer;
import com.gogirl.domain.user.CustomerBalance;
import com.gogirl.domain.user.CustomerBalanceRecord;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.common.util.RandomUtil;
import com.gogirl.infrastructure.config.GogirlProperties;
import com.gogirl.infrastructure.feign.wx.WxPayControllerFeign;
import com.gogirl.infrastructure.mapper.market.DiscountConfigMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import com.gogirl.infrastructure.mapper.user.CustomerBalanceMapper;
import com.gogirl.infrastructure.mapper.user.CustomerBalanceRecordMapper;
import com.gogirl.infrastructure.mapper.user.CustomerMapper;
import com.gogirl.shared.member.order.command.BalanceWxPayQuery;
import com.gogirl.shared.member.order.query.UnifiedOrderQuery;
import com.gogirl.shared.order.serve.query.qry.ordermanage.WxPayOrderQuery;
import com.gogirl.shared.user.command.ConsumerCommand;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

@Service
@AllArgsConstructor
@Slf4j
@Transactional
public class PayServiceImpl implements PayService {


    private final CustomerBalanceMapper customerBalanceMapper;
    private final CustomerBalanceRecordMapper customerBalanceRecordMapper;
    private final CustomerMapper customerMapper;
    private final DiscountConfigMapper discountConfigMapper;

    private final OrderManageService orderManageService;
    private final MarketService marketService;
    private final WxPayControllerFeign wxPayControllerFeign;


    private final GogirlProperties gogirlProperties;
    private final CustomerBalanceService customerBalanceService;
    private final OrderManageMapper orderManageMapper;

    @Override
    public void consumeBalance(Integer currentCustomerId, Integer orderId) {

        OrderManage orderManage = orderManageService.queryOrder(orderId);

        /*step1.扣除余额*/
        ConsumerCommand consumerCmd = ConsumerCommand.builder()
                .amount(orderManage.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue())
                .customerId(currentCustomerId)
                .departmentId(orderManage.getDepartmentId())
                .orderId(orderId)
                .orderStatus(orderManage.getStatus())
                .build();
        customerBalanceService.consumer(consumerCmd);

        /*step2.更新订单*/
        orderManage.setRemark("余额支付");
        orderManageService.updateById(orderManage);


        orderManage.setFinishTime(new Date());
        orderManage.setPaymentType(OrderManage.PAYMENT_BALANCE);
        orderManage.setStatus(OrderManage.STATUS_UN_COMMENT);
        orderManageService.updateById(orderManage);


        /*step3.更新卡券状态*/
        log.debug("更新卡券状态");
        marketService.setterOrderMarket(orderManage.getId());
    }

    @Override
    public void notifyOrder(String wxScheduleOrderNo, Integer paymentType) {

        String orderNo = wxScheduleOrderNo.substring(6);
        OrderManage orderManage = orderManageService.queryOrderByOrderNo(orderNo);

        /*1.更新订单状态*/
        log.info("设置订单折扣详情 orderManageDTO {}", orderManage);

        log.info("更新订单状态");
        //订单状态 待评价
        orderManage.setStatus(OrderManage.STATUS_UN_COMMENT);

        //支付方式
        orderManage.setPaymentType(paymentType);
        orderManage.setFinishTime(new Date());
        orderManage.setUpdateTime(new Date());
        orderManageService.updateById(orderManage);

        /*2.更新卡券状态*/
        marketService.setterOrderMarket(orderManage.getId());

    }

    @Override
    public void notifyCharge(WxPayOrderNotifyResult result) {

        Customer customer = customerMapper.selectOne(new LambdaQueryWrapper<Customer>().eq(Customer::getOpenid1, result.getOpenid()));

        CustomerBalance customerBalance = customerBalanceMapper.selectOne(new LambdaQueryWrapper<CustomerBalance>().eq(CustomerBalance::getCustomerId, customer.getId()));

        DiscountConfig discountConfig = discountConfigMapper.selectList(new LambdaQueryWrapper<>())
                .stream().filter(config -> config.getChargeAmount() <= result.getTotalFee())
                .max(Comparator.comparing(DiscountConfig::getChargeAmount)).orElseThrow(RRException::new);

        //首次充值
        if (customerBalance == null || customerBalance.getBalance() == 0) {
            customerBalance = CustomerBalance.builder()
                    //充值金额+赠送金额
//                    .balance(result.getTotalFee() + discountConfig.getBestowAmount())
                    .balance(result.getTotalFee())

                    .customerId(customer.getId())
                    .currentDiscount(1.00)
                    .discountRate(0.00)
                    .firstChargeTime(new Date())
                    .level(discountConfig.getLevel())
                    //赠送金额
//                    .totalBestow(discountConfig.getBestowAmount())
                    .totalBestow(0)
                    //总充值金额
                    .totalCharge(result.getTotalFee())
                    .totalExpenditure(0)
                    .updateTime(new Date())
                    .version(5)
                    .build();

            //会员卡不存在
            if (customerBalance.getId() == null) {
                customerBalanceMapper.insert(customerBalance);

            }
            //会员卡存在
            else {
                customerBalanceMapper.updateById(customerBalance);
            }

            CustomerBalanceRecord customerBalanceRecord = CustomerBalanceRecord.builder()
                    .time(new Date())
                    .orderId(result.getOutTradeNo())
                    .orderAmount(result.getTotalFee())
                    .discount(1.00)
                    .currentBalance(customerBalance.getBalance())
                    .bestowAmount(0)
                    //赠送金额
//                    .bestowAmount(discountConfig.getBestowAmount())
                    //首次充值
                    .type(1)
                    .customerId(customer.getId())
                    //微信支付
                    .source(1)
                    .build();
            customerBalanceRecordMapper.insert(customerBalanceRecord);
        }

        //充值
        else {
            //更新用户余额
//            customerBalance.setBalance(customerBalance.getBalance() + result.getTotalFee() + discountConfig.getBestowAmount());
            customerBalance.setBalance(customerBalance.getBalance() + result.getTotalFee());
            customerBalance.setLevel(discountConfig.getLevel());
            customerBalance.setUpdateTime(new Date());
            //总送
//            customerBalance.setTotalBestow(customerBalance.getTotalBestow());
            customerBalance.setTotalCharge(customerBalance.getTotalCharge() + result.getTotalFee());
            customerBalanceMapper.updateById(customerBalance);

            //
            CustomerBalanceRecord customerBalanceRecord = CustomerBalanceRecord.builder()
                    .time(new Date())
                    .orderId(result.getOutTradeNo())
                    .orderAmount(result.getTotalFee())
                    .discount(1.00)
                    .currentBalance(customerBalance.getBalance())
//                    .bestowAmount(discountConfig.getBestowAmount())
                    .bestowAmount(0)
                    //首次充值
                    .type(1)
                    .customerId(customer.getId())
                    //微信支付
                    .source(1)
                    .build();
            customerBalanceRecordMapper.insert(customerBalanceRecord);
        }

    }

    @Override
    public void notifyBalanceWxPay(String wxScheduleOrderNo) {
        String orderNo = wxScheduleOrderNo.substring(6);

        OrderManage orderManage = orderManageService.queryOrderByOrderNo(orderNo);


        log.info("更新订单状态");

        //订单状态 待评价
        orderManage.setStatus(OrderManage.STATUS_UN_COMMENT);

        //支付方式
        orderManage.setPaymentType(12);
        orderManage.setFinishTime(new Date());
        orderManage.setUpdateTime(new Date());

        orderManageService.updateById((orderManage));


        log.info("扣除余额");
        CustomerBalance customerBalance = customerBalanceMapper.selectById(orderManage.getOrderUser());
        ConsumerCommand consumerCmd = ConsumerCommand.builder()
                .amount(customerBalance.getBalance())
                .customerId(orderManage.getOrderUser())
                .departmentId(orderManage.getDepartmentId())
                .orderId(orderManage.getId())
                .orderStatus(orderManage.getStatus())
                .build();
        customerBalanceService.consumer(consumerCmd);

        BigDecimal balanceAmount = new BigDecimal(customerBalance.getBalance()).divide(new BigDecimal(100), 2, BigDecimal.ROUND_HALF_UP);
        BigDecimal wxAmount = orderManage.getTotalPaymentAmount().subtract(balanceAmount);

        MultiPaymentType wxMultiPaymentType = MultiPaymentType.builder()
                .price(wxAmount)
                .type(1).build();
        MultiPaymentType balanceMultiPaymentType = MultiPaymentType.builder()
                .price(balanceAmount)
                .type(2).build();
        orderManage.setMultiplePaymentType(JsonUtilByFsJson.beanToJson(Lists.newArrayList(wxMultiPaymentType, balanceMultiPaymentType)));

        marketService.setterOrder(orderManage.getId());
    }

    @Override
    public WxPayMpOrderResult unifiedOrder(UnifiedOrderQuery qry) throws UnknownHostException, WxPayException {

        OrderManage orderManage = orderManageService.queryOrder(qry.getOrderId());

        WxPayOrderQuery qry2 = WxPayOrderQuery
                .builder()
                .currentCustomerId(qry.getCustomerId())
                .openid(qry.getOpenid())
                //避免同单不同金额的情况
                .orderNo(RandomUtil.randomInt(100000, 999999) + orderManage.getOrderNo())
                .totalPaymentAmount(orderManage.getTotalPaymentAmount())
                .build();

        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest =
                WxPayUnifiedOrderRequest.newBuilder()
                        .openid(qry.getOpenid())
                        .tradeType("JSAPI")
                        //todo
                        .notifyUrl(gogirlProperties.getNotifyOrder())
                        .spbillCreateIp(InetAddress.getLocalHost().getHostAddress())
                        .totalFee(qry2.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue())
                        .outTradeNo(qry2.getOrderNo())
                        .body("gogirl美甲美睫")
                        .build();
        log.info("**微信下单参数构造**,{}", wxPayUnifiedOrderRequest.toString());

        wxPayUnifiedOrderRequest.setNotifyUrl(gogirlProperties.getNotifyOrder());
        //微信统一下单
        return wxPayControllerFeign.createJsapiOrder(wxPayUnifiedOrderRequest);

    }

    @Override
    public WxPayMpOrderResult balanceWxPay(BalanceWxPayQuery qry) throws UnknownHostException, WxPayException {

        OrderManage orderManageDTO = orderManageService.queryOrder(qry.getOrderId());

        CustomerBalance customerBalance = customerBalanceMapper.selectByCustomerId(qry.getCustomerId());

        if (orderManageDTO.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue() < customerBalance.getBalance()) {
            throw new RRException("请使用余额支付");
        }

        BigDecimal leftTotalPaymentAmount = orderManageDTO.getTotalPaymentAmount().subtract(new BigDecimal(customerBalance.getBalance()).divide(new BigDecimal(100), 2, BigDecimal.ROUND_HALF_UP));

        WxPayOrderQuery wxPayOrderQuery = WxPayOrderQuery.builder()
                //避免同单不同金额的情况
                .orderNo(RandomUtil.randomInt(100000, 999999) + orderManageDTO.getOrderNo())
                .currentCustomerId(qry.getCustomerId())
                .openid(qry.getOpenid())
                .totalPaymentAmount(leftTotalPaymentAmount)
                .build();

        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest =
                WxPayUnifiedOrderRequest.newBuilder()
                        .openid(qry.getOpenid())
                        .tradeType("JSAPI")
                        //todo
                        .notifyUrl(gogirlProperties.getNotifyBalanceWxPay())
                        .spbillCreateIp(InetAddress.getLocalHost().getHostAddress())
                        .totalFee(wxPayOrderQuery.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue())
                        .outTradeNo(wxPayOrderQuery.getOrderNo())
                        .body("gogirl美甲美睫")
                        .build();

        log.info("**微信下单参数构造**,{}", wxPayUnifiedOrderRequest.toString());
        //微信统一下单
        return wxPayControllerFeign.createJsapiOrder(wxPayUnifiedOrderRequest);
    }

    @Override
    public void balancePosPay(Integer currentCustomerId, Integer orderId) {
        OrderManage orderManage = orderManageService.getById(orderId);

        CustomerBalance customerBalance = customerBalanceMapper.selectByCustomerId(currentCustomerId);

        if (orderManage.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue() < customerBalance.getBalance()) {
            throw new RRException("请使用余额支付");
        }
        //申请余额pos支付
        orderManage.setPaymentType(13);


        //多种方式支付字段构建
        BigDecimal balanceAmount = new BigDecimal(customerBalance.getBalance()).divide(new BigDecimal(100), 100, BigDecimal.ROUND_HALF_UP);

        MultiPaymentType balancePay = new MultiPaymentType(2, balanceAmount);
        MultiPaymentType posPay = new MultiPaymentType(5, orderManage.getTotalPaymentAmount().subtract(balanceAmount));

        List<MultiPaymentType> multiPaymentTypeList = Lists.newArrayList(balancePay, posPay);

        orderManage.setMultiplePaymentType(JsonUtilByFsJson.beanToJson(multiPaymentTypeList));

        //待确认支付
        orderManage.setStatus(8);
        orderManageService.updateById(orderManage);
    }

    @Override
    public void chosePayType(Integer orderId, Integer payType) {

        OrderManage orderManage = orderManageMapper.selectById(orderId);

        //客户申请pos机支付
        if (payType.equals(5)) {
            //状态待确认
            orderManage.setStatus(OrderManage.STATUS_UN_CONFIRM);
            //支付类型状态pos机
            orderManage.setPaymentType(OrderManage.PAYMENT_POS);
            orderManageMapper.updateById(orderManage);
        }
        //客户申请团购支付
        if (payType.equals(7)) {
            //状态待确认
            orderManage.setStatus(OrderManage.STATUS_UN_CONFIRM);
            //支付类型状态pos机
            orderManage.setPaymentType(OrderManage.PAYMENT_DZ);
            orderManageMapper.updateById(orderManage);
        }
        throw new RRException(500, "invalid payType");
    }
}
