package com.gogirl.infrastructure.mapper.store.store;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.domain.store.store.StoreManage;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by yinyong on 2018/9/17.
 */

@Repository
public interface StoreManageMapper extends BaseMapper<StoreManage> {

    /**
     * 分页获取店铺列表
     *
     * @param page
     * @param storeManage
     * @return
     */
    IPage<StoreManage> listShopManageForPage(IPage<StoreManage> page, @Param("storeManage") StoreManage storeManage);

    /**
     * 获取美甲师绑定的店铺列表
     *
     * @param technicianId 美甲师id
     * @return list
     */
    List<StoreManage> getTechnicianShopList(Integer technicianId);
}
