package com.gogirl.interfaces.xcx;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.gogirl.application.order.serve.OrderManageService;
import com.gogirl.application.order.serve.ScheduleManageService;
import com.gogirl.application.store.store.StoreTechnicianService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.application.xcx.QRCodeService;
import com.gogirl.application.xcx.WechatService;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.order.serve.ScheduleManage;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.user.Customer;
import com.gogirl.domain.user.CustomerBalance;
import com.gogirl.domain.user.CustomerDetail;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.annotation.GogirlMember;
import com.gogirl.infrastructure.common.annotation.GogirlShop;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.config.GogirlProperties;
import com.gogirl.infrastructure.mapper.order.serve.ScheduleManageMapper;
import com.gogirl.infrastructure.mapper.user.CustomerBalanceMapper;
import com.gogirl.infrastructure.mapper.user.CustomerDetailMapper;
import com.gogirl.infrastructure.mapper.user.CustomerMapper;
import com.gogirl.infrastructure.mapper.xcx.GogirlTokenMapper;
import com.gogirl.infrastructure.util.ImageUtil;
import com.gogirl.infrastructure.util.WXCore;
import com.gogirl.infrastructure.util.lock.Openid1Lock;
import com.gogirl.shared.member.wx.query.dto.Code2SessionResult;
import com.gogirl.shared.user.query.qry.CustomerQuery;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@RestController
@AllArgsConstructor
@Slf4j
@Api(tags = "version2.0: 小程和用户相关接口")
public class XcxController {

    private final WechatService wechatService;
    private final GogirlTokenService gogirlTokenService;
    private final GogirlProperties gogirlProperties;

    private final GogirlTokenMapper gogirlTokenMapper;
    private final CustomerMapper customerMapper;


    private final QRCodeService qrCodeService;
    private final CustomerBalanceMapper customerBalanceMapper;
    private final CustomerDetailMapper customerDetailMapper;
    private final ScheduleManageMapper scheduleManageMapper;
    private final ScheduleManageService scheduleManageService;
    private final StoreTechnicianService storeTechnicianService;
    private final OrderManageService orderManageService;

    /**
     * 将emoji表情替换成空串
     *
     * @param source
     * @return 过滤后的字符串
     */
    private static String filterEmoji(String source) {
        if (source != null && source.length() > 0) {
            return source.replaceAll("[\ud800\udc00-\udbff\udfff\ud800-\udfff]", "");
        } else {
            return source;
        }
    }

    @ApiOperation("用户授权接街道地址信息")
    @GetMapping("/customer/xcx/bindAddressInfo")
    public JsonResult<String> bindAddressInfo(@RequestParam Integer customerId,
                                              @RequestParam String province,
                                              @RequestParam String city,
                                              @RequestParam String area,
                                              @RequestParam String street) {
        Customer customer = customerMapper.selectById(customerId);

        customer.setProvince(province);
        customer.setCity(city);
        customer.setArea(area);
        customer.setStreet(street);
        customerMapper.updateById(customer);

        return JsonResult.success();
    }

    @ApiOperation(("查询会员"))
    @PostMapping("/customer/xcx/query")
    public JsonResult<Customer> query(@RequestBody CustomerQuery qry) {
        Customer customer = customerMapper.selectById(qry.getCustomerId());
        return JsonResult.success(customer);
    }

    @ApiOperation(value = "客户根据code获取token")
    @RequestMapping(method = {RequestMethod.GET}, value = "/customer/xcx/login")
    public JsonResult<String> login(@RequestParam String code) {

        log.info("调用login，授权用户信息到程序 code:{}", code);

        Openid1Lock lock = Openid1Lock.getInsatance();


        Code2SessionResult result = wechatService.getOpenidByCode(code);

        String token = IdWorker.getIdStr();

        //创建token
        GogirlToken gogirlToken = GogirlToken.builder()
                .code(code)
                .sysId(1)
                .openid(result.getOpenid())
                .sessionKey(result.getSessionKey())
                .createTime(new Date())
                .updateTime(new Date())
                .unionid(result.getUnionid())
                .token(token)
                .build();


        String openid = gogirlToken.getOpenid();

        try {
            lock.lock(openid1GetInt(openid));
            //变量为当前登陆用户
            Customer customer;

            customer = customerMapper.selectOne(new LambdaQueryWrapper<Customer>().eq(Customer::getOpenid1, openid));
            //不存在小程序用户
            if (customer == null) {
                //token unionid 不为空
                if (StringUtils.isNotEmpty(result.getUnionid())) {

                    customer = customerMapper.selectOne(new LambdaQueryWrapper<Customer>().eq(Customer::getUnionid, result.getUnionid()));
                    //不存在公众号用户
                    if (customer == null) {
                        customer = Customer.builder()
                                .customerSource(4)
                                //小程序openid
                                .openid1(openid)
                                .orderTimes(0)
                                .registerTime(new Date())
                                .scheduledTimes(0)
                                //微信授权
                                .source(3)
                                //状态 正常
                                .state("1")
                                .updateTime(new Date())
                                .build();

                        customerMapper.insert(customer);
                    }
                    // 存在公众号用户
                    else {
                        customer.setOpenid1(openid);
                        customerMapper.updateById(customer);
                    }
                }
                //union id为空
                else {
                    customer = Customer.builder()
                            .customerSource(4)
                            //小程序openid
                            .openid1(openid)
                            .orderTimes(0)
                            .registerTime(new Date())
                            .scheduledTimes(0)
                            //微信授权
                            .source(3)
                            //状态 正常
                            .state("1")
                            .updateTime(new Date())
                            .build();
                    customerMapper.insert(customer);
                }

            }

            gogirlToken.setCustomerId(customer.getId());
            gogirlTokenMapper.insert(gogirlToken);

        } finally {
            lock.unlock(openid1GetInt(openid));
        }

        return JsonResult.success(token);
    }

    @ApiOperation(value = "客户授权后绑定个人信息")
    @RequestMapping(method = {RequestMethod.GET, RequestMethod.POST}, value = "/customer/xcx/authorized1")
    public JsonResult<Customer> Authorization1(
            @RequestParam(name = "token", required = false) String token,
            @RequestParam(name = "encryptedData", required = false) String encryptedData,
            @RequestParam(name = "iv", required = false) String iv) throws InvalidAlgorithmParameterException {

        log.info("调用authorized，授权用户信息到程序");

        GogirlToken gogirlToken = gogirlTokenService.getTokenByToken(token);
        JSONObject data = WXCore.decrypt(encryptedData, gogirlToken.getSessionKey(), iv);
        String unionid = (String) data.get("unionId");
        String openid = (String) data.get("openId");
        Integer gender = (Integer) data.get("gender");
        String avatarUrl = (String) data.get("avatarUrl");
        String city = (String) data.get("city");
        String country = (String) data.get("country");
        String province = (String) data.get("province");
        String nickName = filterEmoji((String) data.get("nickName"));

        Customer customer = customerMapper.selectOne(new LambdaQueryWrapper<Customer>().eq(Customer::getOpenid1, openid));

        customer.setSex(gender == 1 ? "男" : gender == 2 ? "女" : "未知");
        customer.setHeadimgurl(avatarUrl);
        customer.setNickname(nickName);
        customer.setProvince(province);
        customer.setCountry(country);
        customer.setCity(city);
        customer.setUnionid(unionid);
        customerMapper.updateById(customer);

        return JsonResult.success(customer);
    }

    @ApiOperation(value = "客户授权手机号码")
    @RequestMapping(method = {RequestMethod.POST}, value = "/customer/xcx/authorizedPhone")
    public JsonResult<Customer> authorizedPhone(@RequestHeader String token,
                                                @RequestParam String encryptedData,
                                                @RequestParam String iv) throws InvalidAlgorithmParameterException {
        GogirlToken gogirlToken = gogirlTokenService.getTokenByToken(token);

        log.info("手机号码授权,用户信息:" + gogirlToken.getCustomer());

        JSONObject data = WXCore.decrypt(encryptedData, gogirlToken.getSessionKey(), iv);

        String phone = (String) data.get("purePhoneNumber");

        gogirlToken.setPhone(phone);
        gogirlTokenMapper.updateById(gogirlToken);

        Customer customer = customerMapper.selectById(gogirlToken.getCustomerId());


        Customer phoneCustomer = customerMapper.selectOne(new LambdaQueryWrapper<Customer>().eq(Customer::getPhone, phone));

        //如果存在手机号
        if (phoneCustomer != null) {

            phoneCustomer.setSex(customer.getSex());
            phoneCustomer.setHeadimgurl(customer.getHeadimgurl());
            phoneCustomer.setNickname(customer.getNickname());
            phoneCustomer.setProvince(customer.getProvince());
            phoneCustomer.setCountry(customer.getCountry());
            phoneCustomer.setCity(customer.getCity());
            phoneCustomer.setUnionid(customer.getUnionid());

            phoneCustomer.setCustomerSource(customer.getCustomerSource());
            phoneCustomer.setOpenid1(customer.getOpenid1());
            phoneCustomer.setRegisterTime(customer.getRegisterTime());
            phoneCustomer.setScheduledTimes(customer.getScheduledTimes());
            phoneCustomer.setSource(customer.getSource());
            phoneCustomer.setState(customer.getState());
            phoneCustomer.setUpdateTime(new Date());

            customerMapper.updateById(phoneCustomer);

            customerMapper.deleteById(customer);

            List<ScheduleManage> scheduleManageList = scheduleManageService.list(new LambdaQueryWrapper<ScheduleManage>()
                    .eq(ScheduleManage::getTelephone, phone));
            if (ListUtil.isNotEmpty(scheduleManageList)) {
//                scheduleManageService.
                scheduleManageList.forEach(scheduleManage -> scheduleManage.setTelephone(phone));
                scheduleManageService.saveBatch(scheduleManageList);
            }
            //清除token
            gogirlTokenMapper.delete(new LambdaQueryWrapper<GogirlToken>().eq(GogirlToken::getCustomerId, customer.getId()));
            return JsonResult.success(phoneCustomer);
        }
        //不存在手机号
        else {

            customer.setPhone(phone);
            customerMapper.updateById(customer);
            return JsonResult.success(customer);
        }
    }

    @RequestMapping(method = {RequestMethod.GET}, value = "/customer/xcx/getUserInfo")
    @ApiOperation(value = "客户根据token获取用户信息")
    @ApiImplicitParam(paramType = "query", name = "token", value = "token编号", required = true, dataType = "String")
    @GogirlMember
    public JsonResult<Customer> getUserInfo(@RequestParam String token) throws Exception {

        log.info("根据token:" + token + ",查询用户信息.");
        GogirlToken gogirlToken = gogirlTokenService.getTokenByToken(token);

        Customer customer = customerMapper.selectById(gogirlToken.getCustomerId());
        CustomerDetail customerDetail = customerDetailMapper.selectOne(new LambdaQueryWrapper<CustomerDetail>().eq(CustomerDetail::getCustomerId, customer.getId()));
        CustomerBalance customerBalance = customerBalanceMapper.selectOne(new LambdaQueryWrapper<CustomerBalance>().eq(CustomerBalance::getCustomerId, customer.getId()));


        customer.setCustomerDetail(customerDetail);
        customer.setCustomerBalance(customerBalance);

        if (StringUtils.isEmpty(customer.getMyQrcode()) && StringUtils.isNotEmpty(customer.getPhone())) {
            String myQrCode = qrCodeService.myQrCode(customer.getId().toString(), customer.getPhone());
            customer.setMyQrcode(myQrCode);
            customer.setId(customer.getId());
            customer.setMyQrcode(myQrCode);

            customerMapper.updateById(customer);
        }

        return JsonResult.success(customer);

    }

    @ApiOperation(value = "图片上传")
    @RequestMapping(method = {RequestMethod.POST}, value = "/customer/xcx/upload")
    @GogirlMember
    @GogirlShop
    public JsonResult<String> upload(MultipartFile file) throws Exception {
        log.info("图片上传");
        if (file == null) {
            throw new RRException("图片为空");
        }
        String imgUrl = ImageUtil.saveImage(gogirlProperties.getPicturePath(), file);
        return JsonResult.success(imgUrl);
    }

    @ApiOperation(value = "美甲师根据code获取token")
    @GetMapping(value = "/technician/xcx/login_t")
    public JsonResult<String> login_t(@RequestParam String code) {

        log.info("调用login，授权用户信息到程序 code:{} 获取用户信息 ", code);

        Code2SessionResult responseResult = wechatService.getOpenidByCode(code);

        if (responseResult.getErrcode() != null) {
            throw new RRException(responseResult.getErrmsg());
        }

        String openid = responseResult.getOpenid();

        //生成token
        String token = new BigInteger((int) (Math.random() * 1000) + new SimpleDateFormat("ddHHmmss").format(new Date()), 10).toString(16);

        StoreTechnician param = new StoreTechnician();
        param.setOpenid(openid);

        List<StoreTechnician> list = storeTechnicianService.listTechnicianForPage(param);

        GogirlToken gogirlToken = new GogirlToken();

        if (ListUtil.isNotEmpty(list) && list.size() == 1) {
            gogirlToken.setCustomerId(list.get(0).getId());
            gogirlTokenMapper.updateById(gogirlToken);
        }

        //美甲师token
        gogirlToken.setSysId(2);

        gogirlToken.setOpenid(openid);

        // 返回美甲师信息及token
        gogirlToken.setCreateTime(new Date());
        gogirlToken.setUpdateTime(new Date());

        gogirlToken.setToken(token);
        gogirlTokenMapper.insert(gogirlToken);

        return JsonResult.success(token);
    }

    @ApiOperation(value = "美甲师根据token获取美甲师信息")
    @GetMapping("/technician/xcx/getUserInfo_t")
    @GogirlShop
    public JsonResult<List<StoreTechnician>> getUserInfo_t(String token) {

        log.info("根据token:" + token + ",查询用户信息.");

        GogirlToken gogirlToken = gogirlTokenService.getTokenByToken(token);

        //获取美甲师信息
        if (gogirlToken.getCustomerId() != null) {
            StoreTechnician storeTechnician = storeTechnicianService.getTechnicianManageForDetail(gogirlToken.getCustomerId());
            List<StoreTechnician> list = Lists.newArrayList(storeTechnician);
            return JsonResult.success(list);
        }

        //token customerId为空
        else {
            StoreTechnician param = new StoreTechnician();
            param.setOpenid(gogirlToken.getOpenid());
            List<StoreTechnician> list = storeTechnicianService.listTechnicianForPage(param);

            //选择门店
            if (ListUtil.isNotEmpty(list) && list.size() > 1) {
                log.info("美甲师选择门店");
            }

            //set customerId
            else if (ListUtil.isNotEmpty(list) && list.size() == 1) {
                gogirlToken.setCustomerId(list.get(0).getId());
                gogirlTokenMapper.updateById(gogirlToken);
                log.info("存在美甲师, setCustomerId (ssa.id)");
            }

            //list is empty
            else {
                log.info("绑定手机号");
            }
            return JsonResult.success(list);
        }
    }

    @ApiOperation(value = "美甲师选择多门店的账号")
    @RequestMapping(method = {RequestMethod.POST}, value = "/technician/xcx/choseStore")
    @GogirlShop
    public JsonResult<StoreTechnician> choseStore(@RequestParam(name = "token") String token,
                                                  @RequestParam(name = "technicianId") Integer technicianId) {
        log.info("美甲师选择多门店的账号");
        GogirlToken gogirlToken = gogirlTokenService.getTokenByToken(token);
        StoreTechnician technicianManage = storeTechnicianService.getTechnicianManageForDetail(technicianId);
        if (technicianManage == null) {
            throw new RRException("找不到该美甲师账号");
        }
        gogirlToken.setCustomerId(technicianId);
        gogirlTokenService.updateByPrimaryKeySelective(gogirlToken);
        return JsonResult.success(technicianManage);
    }

    @ApiOperation(value = "美甲师选择多门店的账号-根据订单id")
    @RequestMapping(method = {RequestMethod.POST}, value = "/technician/xcx/choseStoreByOrderId")
    public JsonResult<StoreTechnician> choseStoreByOrderId(
            @RequestParam(name = "token") String token,
            @RequestParam(name = "orderId") Integer orderId) {
        log.info("美甲师选择多门店的账号");

        if (token == null || token.isEmpty()) {
            return new JsonResult<>(false, "入参token为空", null);
        }
        if (orderId == null) {
            return new JsonResult<>(false, "入参orderId为空", null);
        }
        GogirlToken gt = gogirlTokenService.getTokenByToken(token);
        if (gt == null) {
            return new JsonResult<>(false, "token过期", null);
        }
        OrderManage orderManage = orderManageService.queryOrder(orderId);
        if (orderManage == null) {
            return new JsonResult<>(false, "找不到订单", null);
        }
        if (orderManage.getDepartmentId() == null) {
            return new JsonResult<>(false, "订单无店铺", null);
        }

        List<StoreTechnician> listStoreTechnician = storeTechnicianService.getTechnicianManageByOpenid(gt.getOpenid());
        if (listStoreTechnician == null) {
            return new JsonResult<>(false, "找不到该美甲师账号", null);
        }
        for (StoreTechnician storeTechnician : listStoreTechnician) {
            if (storeTechnician.getDepartmentId().equals(orderManage.getDepartmentId())) {
                GogirlToken gogirlToken = new GogirlToken();
                gogirlToken.setId(gt.getId());
                gogirlToken.setCustomerId(storeTechnician.getId());
                gogirlTokenService.updateByPrimaryKeySelective(gogirlToken);
                return new JsonResult<>(true, JsonResult.APP_DEFINE_SUC, storeTechnician);
            }
        }
        return new JsonResult<>(true, "无该店铺");
    }

    @ApiOperation(value = "图片上传")
    @RequestMapping(method = {RequestMethod.POST}, value = "/technician/xcx/upload")
    @GogirlMember
    @GogirlShop
    public JsonResult<String> techUpload(MultipartFile file) throws Exception {
        log.info("美甲师选择多门店的账号");
        if (file == null) {
            return new JsonResult<>(false, "file为空", null);
        }
        String imgUrl = ImageUtil.saveImage(gogirlProperties.getPicturePath(), file);

        return new JsonResult<>(true, JsonResult.APP_DEFINE_SUC, imgUrl);
    }

    //字符串中所有字符相加得到一个int
    private int openid1GetInt(String openid1) {
        StringBuilder sb = new StringBuilder(openid1);
        int sum = 0;
        int length = sb.length();
        for (int i = 20; i < length; i++) {
            sum += sb.charAt(i);
        }
        return sum;
    }
}
