package com.gogirl.domain.store.store;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.order.serve.ScheduleServe;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * Created by yinyong on 2018/9/20.
 */
@ApiModel("每天排班记录")
@TableName("store_classes_technician")

@Data
public class StoreClassesTechnician {

    private Integer id;

    @ApiModelProperty("美甲师id 这里是technician_id")
    private Integer userId;

    @ApiModelProperty("哪一天")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date days;

    @ApiModelProperty("班次id")
    private Integer classes;

    @ApiModelProperty("")
    private Integer status;

    /**
     * 非数据库id
     */
    @TableField(exist = false)
    private StoreClasses classesManage;

    @TableField(exist = false)
    private StoreTechnician technicianManage;

    @TableField(exist = false)
    private List<ScheduleServe> listScheduleServe;
}
