package com.gogirl.application.xcx.impl;


import com.gogirl.application.xcx.WechatService;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.config.WxProperties;
import com.gogirl.infrastructure.constant.WxUrlType;
import com.gogirl.shared.member.wx.query.dto.Code2SessionResult;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;


@Service
@AllArgsConstructor
public class WechatServiceImpl implements WechatService {

    private final RestTemplate restTemplate;
    private final WxProperties wxProperties;

    @Override
    public Code2SessionResult getOpenidByCode(String code) {

        String url = WxUrlType.OAuth2_ACCESS_TOKEN_URL
                .replaceAll("APPID", wxProperties.getCustomerMiniAppId())
                .replaceAll("SECRET", wxProperties.getCustomerMiniSecret())
                .replaceAll("JSCODE", code);


        String response = restTemplate.postForEntity(url, null, String.class).getBody();
        return JsonUtilByFsJson.jsonToBean(response, Code2SessionResult.class);
    }

}
