package com.gogirl.infrastructure.mapper.store.store;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gogirl.domain.store.store.StoreClassesTechnician;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;


public interface StoreClassesTechnicianMapper extends BaseMapper<StoreClassesTechnician> {


    /**
     * 查询美甲师排班和美甲师正在做的服务
     *
     * @param scheduleId   如果传id正在做的服务要排除这个预约
     * @param departmentId 店铺id
     * @param days         日志 localDate
     * @return
     */
    List<StoreClassesTechnician> listClassesTechnician(@Param("scheduleId") Integer scheduleId,
                                                       @Param("departmentId") Integer departmentId,
                                                       @Param("days") String days);

    List<StoreClassesTechnician> listClassTimeByStartDate(@Param("startDate") String startDate, @Param("startTime") String startTime, @Param("departmentId") Integer departmentId);

    List<StoreClassesTechnician> listClassesTechnicianDetail(@Param("userId") Integer userId, @Param("days") String days);

    List<StoreClassesTechnician> listClassesTechnicianDetailByDays(@Param("userId") Integer userId, @Param("days") String days);

    int updateClassesTechnician(StoreClassesTechnician storeClassesTechnician);

    int insertClassesTechnician(StoreClassesTechnician storeClassesTechnician);

    List<StoreClassesTechnician> listByDepartmentIdAndDays(@Param("departmentId") Integer departmentId, @Param("days") String days);

    StoreClassesTechnician selectOneClassTech(@Param("departmentId") Integer departmentId, @Param("day") Date day, @Param("technicianId") Integer technicianId);

    List<Integer> deleteDayClassesIds(@Param("departmentId") Integer departmentId, @Param("day") Date day);
}
