package com.gogirl.domain.order.mall;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@TableName("mall_order")
@ApiModel("商城订单")
@Data
public class MallOrder {

    //订单待付款
    public static final Integer STATUS_UN_PAY = 1;
    //订单已付款代发货
    public static final Integer STATUS_UN_SHIP = 2;
    //订单待已发货
    public static final Integer STATUS_SHIPPED = 3;
    //订单已签收
    public static final Integer STATUS_SIGNED = 4;
    //订单已签收
    public static final Integer STATUS_TRADE_CLOSE = 5;
    //订单退款中
    public static final Integer STATUS_REFUNDING = 6;
    public static final Integer PAYMENT_TYPE_WX = 1;
    public static final Integer PAYMENT_TYPE_BALANCE = 2;
    public static final Integer PAYMENT_TYPE_BALANCE_WX = 3;
    public static final Integer TRANSACTION_TYPE_ONLINE = 1;
    //订单关闭原因
    public static final Integer CLOSE_OVERTIME = 1;
    public static final Integer CLOSE_REFUND = 2;
    public static final Integer CLOSE_CUSTOMER_CANCEL = 3;
    @TableId(type = IdType.ID_WORKER)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    @ApiModelProperty("顾客id")
    private Integer customerId;
    @ApiModelProperty("交易方式 1-线上交易")
    private Integer transactionType;
    @ApiModelProperty("下单时间")
    private Long orderTime;
    @ApiModelProperty("支付时间")
    private Long paymentTime;
    @ApiModelProperty("订单总金额")
    private BigDecimal totalAmount;
    @ApiModelProperty("运费")
    private BigDecimal freight;
    @ApiModelProperty("总优惠金额")
    private BigDecimal totalDiscountAmount;
    @ApiModelProperty("实际支付总金额")
    private BigDecimal totalPayAmount;
    @ApiModelProperty("配送方式 1-邮寄 2-自取")
    private Integer transportMode;
    @ApiModelProperty("支付方式 1-微信支付 2-余额支付 3-余额抵扣微信支付")
    private Integer paymentType;
    @TableField(exist = false)
    @ApiModelProperty("是否朋友代付 1-是 2-否")
    private Integer isFriendPay;
    @ApiModelProperty("付款客户")
    private Integer paymentCustomerId;
    @ApiModelProperty("订单类型")
    private Integer type;
    @ApiModelProperty("订单状态 1-订单待付款 2-订单已付款 3-订单已发货 4-订单已签收 5-交易关闭 6-订单退款中")
    private Integer status;
    @ApiModelProperty("订单关闭原因 1-超时关闭 2-退款关闭 3-用户取消")
    private Integer closeReason;
    @ApiModelProperty("顾客留言备注")
    private String customerRemark;
    @ApiModelProperty("自提店铺id")
    private Integer selfTakeDepartmentId;
    @ApiModelProperty("自提店铺地址")
    private String selfTakeDepartmentAddress;
    @ApiModelProperty("自提客户手机号")
    private String selfTakePhone;
    @ApiModelProperty("版本号")
    @Version
    private Long version;
    private Long createTime;
    @ApiModelProperty("订单收货地址")
    @TableField(exist = false)
    private MallOrderAddress mallOrderAddress;
    @TableField(exist = false)
    @ApiModelProperty("订单详情")
    private List<MallOrderDetail> mallOrderDetailList;
    @ApiModelProperty("状态机备注")
    private String remark;
    @ApiModelProperty(value = "配送地址id", required = true)
    private Long mallOrderAddressId;

}

