package com.gogirl.application.order.market.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.gogirl.application.order.market.ITimesCardOrderService;
import com.gogirl.domain.market.timescard.TimesCardCustomerRelevance;
import com.gogirl.domain.market.timescard.TimesCardType;
import com.gogirl.domain.order.market.TimesCardOrder;
import com.gogirl.infrastructure.mapper.market.timescard.TimesCardCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.market.timescard.TimesCardTypeMapper;
import com.gogirl.infrastructure.mapper.order.market.TimesCardOrderMapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-03-08
 */
@Service
@AllArgsConstructor
@Slf4j
public class TimesCardOrderServiceImpl extends ServiceImpl<TimesCardOrderMapper, TimesCardOrder> implements ITimesCardOrderService {

    private final TimesCardTypeMapper timesCardTypeMapper;
    private final TimesCardCustomerRelevanceMapper timesCardCustomerRelevanceMapper;

    @Override
    public void notifyTimesCardOrder(WxPayOrderNotifyResult result) {
        String attach = result.getAttach();
        String timesCardIdString = attach.split(",")[0];
        String customerIdString = attach.split(",")[1];
        Integer timesCardTypeId = Integer.parseInt(timesCardIdString);
        Integer customerId = Integer.parseInt(customerIdString);

        TimesCardType timesCardType = timesCardTypeMapper.selectById(timesCardTypeId);
        //次卡
        TimesCardCustomerRelevance timesCardCustomerRelevance = TimesCardCustomerRelevance.builder()
                //次卡类型id
                .cardTypeId(timesCardTypeId)
                //次卡类型名称
                .name(timesCardType.getName())
                //会员id
                .customerId(customerId)

                .sumTimes(timesCardType.getSumTimes())
                .usedTimes(0)
                .createTime(new Date())
                .discountAmount(timesCardType.getDiscountAmount())
                .payAmount(timesCardType.getPayAmount())
                .refereeId(null)
                .status(TimesCardCustomerRelevance.STATUS_NORMAL)
                .validStartTime(new Date())
                .validEndTime(new Date(System.currentTimeMillis() + timesCardType.getValidDays() * 24 * 60 * 60 * 1000L))
                .build();

        timesCardCustomerRelevanceMapper.insert(timesCardCustomerRelevance);
    }
}
