package com.gogirl.infrastructure.util;

import com.gogirl.domain.product.mall.MallCategory;

import java.util.ArrayList;
import java.util.List;

/**
 * 树结构工具类
 *
 * @author mochunrun
 */
public class TreeUtils {


    /**
     * 方法二、
     *
     * @param list
     * @return
     */
    public static List<MallCategory> listToTree(List<MallCategory> list) {
        //用递归找子。
        List<MallCategory> treeList = new ArrayList<>();
        for (MallCategory tree : list) {
            if (tree.getParentId() == 0) {
                MallCategory child = findChildren(tree, list);
                if (child.getCount() > 0) {
                    treeList.add(child);
                }
            }
        }
        return treeList;
    }


    private static MallCategory findChildren(MallCategory tree, List<MallCategory> list) {
        for (MallCategory node : list) {
            if (node.getParentId().equals(tree.getId())) {
                if (tree.getChildList() == null) {
                    tree.setChildList(new ArrayList<>());
                }
                MallCategory child = findChildren(node, list);
                if (child.getCount() > 0) {
                    int count = tree.getCount() + child.getCount();
                    tree.getChildList().add(child);
                    tree.setCount(count);
                }
            }
        }
        return tree;
    }

}
