package com.gogirl.application.store.complaint.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.complaint.ComplaintDetailedService;
import com.gogirl.application.store.complaint.ComplaintMainService;
import com.gogirl.domain.store.complaint.ComplaintDetailed;
import com.gogirl.domain.store.complaint.ComplaintMain;
import com.gogirl.domain.user.investigation.OrderQuestionOption;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.store.complaint.ComplaintMainMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author luobin
 * @since 2019-11-23
 */
@Service
public class ComplaintMainServiceImpl extends ServiceImpl<ComplaintMainMapper, ComplaintMain> implements ComplaintMainService {

    @Autowired
    ComplaintDetailedService complaintDetailedService;

    @Override
    public void saveComplainsByOrderQuestion(List<OrderQuestionOption> list) {

        list = list.stream()
                .filter(orderQuestionOption -> orderQuestionOption.getComplaintSkuId() != null && orderQuestionOption.getComplaintSkuId() > 0)
                .collect(Collectors.toList());

        if (ListUtil.isNotEmpty(list)) {

            ComplaintMain complaintMain = new ComplaintMain();

            OrderQuestionOption orderQuestionOption = list.stream().findAny().orElseThrow(RRException::new);
            complaintMain.setOrderId(orderQuestionOption.getOrderId());
            complaintMain.setCreateDate(LocalDateTime.now());
            complaintMain.setCustomerId(orderQuestionOption.getCustomerId());
            complaintMain.setPicturePath(null);
            complaintMain.setRemarks(null);
            complaintMain.setSource(ComplaintMain.SOURCE_MP);
            complaintMain.setCreateUser(orderQuestionOption.getCustomerId());
            this.save(complaintMain);

            List<ComplaintDetailed> complaintDetailedList = list
                    .stream()
                    .map(orderQuestionOption1 -> {
                        ComplaintDetailed complaintDetailed = new ComplaintDetailed();
                        complaintDetailed.setComplaintSkuType(orderQuestionOption1.getComplaintType());
                        complaintDetailed.setContent(orderQuestionOption1.getRemarks());
                        complaintDetailed.setMainId(complaintMain.getId());
                        complaintDetailed.setCreateDate(LocalDateTime.now());
                        complaintDetailed.setSkuId(orderQuestionOption1.getComplaintSkuId());
                        return complaintDetailed;
                    })
                    .collect(Collectors.toList());

            complaintDetailedService.saveBatch(complaintDetailedList);
        }
    }
}
