package com.gogirl.interfaces.store.technician;

import com.gogirl.application.store.store.StoreTechnicianService;
import com.gogirl.application.store.store.StoreUserService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.store.store.StoreUser;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.annotation.GogirlShop;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.config.property.GogirlProperties;
import com.gogirl.infrastructure.service.file.FileService;
import com.gogirl.infrastructure.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.List;

@Api("美甲师接口")
@RestController
@Slf4j
public class StoreTechnicianController {

    @Resource
    GogirlTokenService gogirlTokenService;
    @Resource
    private StoreUserService storeUserService;
    @Resource
    StoreTechnicianService storeTechnicianService;
    @Resource
    GogirlProperties gogirlProperties;
    @Resource
    FileService fileService;

    @ApiOperation("/查询美甲师信息")
    @GetMapping("/customer/technician/getById")
    public JsonResult<StoreTechnician> getById(@RequestParam Integer id) {
        return JsonResult.success(storeTechnicianService.getById(id));
    }

    @ApiOperation(value = "查询当前店铺的美甲师,选推荐人")
    @GetMapping("/technician/user/queryUserForAll")
    @GogirlShop
    public JsonResult<List<StoreUser>> queryUserForAll(String token) {
        GogirlToken gt = gogirlTokenService.getByToken(token);
        if (gt == null) {
            return new JsonResult<>(false, "TOKEN_NULL_CODE");
        }
        JsonResult<List<StoreUser>> jsonResult = new JsonResult<>();
        StoreUser storeUser = new StoreUser();
        storeUser.setDepartmentId(SessionUtils.getTechnicianToken().getDepartmentId());
        List<StoreUser> lists = storeUserService.listUserForAllNotQuit(storeUser);

        jsonResult.setSuccess(JsonResult.CODE_SUCCESS)
                .setMessage(JsonResult.APP_DEFINE_SUC)
                .setData(lists);
        return jsonResult;
    }

    @ApiOperation(value = "美甲师根据code获取token")
    @GetMapping(value = "/technician/xcx/login_t")
    public JsonResult<String> technicianLogin(@RequestParam String code) {
        log.info("调用login，授权用户信息到程序 code:{} 获取用户信息 ", code);
        String token = storeTechnicianService.login(code);
        return JsonResult.success(token);
    }

    @ApiOperation(value = "美甲师根据token获取美甲师信息")
    @GetMapping("/technician/xcx/getUserInfo_t")
    public JsonResult<StoreTechnician> getTechnician(@RequestHeader String token) {
        log.info("根据token:" + token + ",查询用户信息.");
        StoreTechnician storeTechnician = storeTechnicianService.getTechnician();
        return JsonResult.success(storeTechnician);
    }


    @ApiOperation(value = "美甲师选择多门店的账号")
    @PostMapping("/technician/xcx/choseStore")
    public JsonResult<Void> choseStore(@RequestParam(name = "token") String token,
                                       @RequestParam Integer departmentId) {
        log.info("美甲师选择多门店的账号");
        storeTechnicianService.choseStore(departmentId);
        return JsonResult.success();
    }

    @ApiOperation(value = "图片上传")
    @RequestMapping("/technician/xcx/upload")
    public JsonResult<String> techUpload(MultipartFile file) throws Exception {
        String imgUrl = fileService.saveImage(file);
        return JsonResult.success(imgUrl);
    }
}
