package com.gogirl.infrastructure.mapper.market.coupon;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;


public interface CouponCustomerRelevanceMapper extends BaseMapper<CouponCustomerRelevance> {


    /**
     * 查询用户同一类型卡券的领取次数
     *
     * @param couponId   卡券类型id
     * @param customerId 用户id
     * @return
     */
    int countRelevanceNum(@Param("couponId") Integer couponId, @Param("customerId") Integer customerId);

    /**
     * 设置过期卡券状态为已过期
     *
     * @param nowDate
     * @return
     */
    int setCouponExpire(Date nowDate);

    /**
     * 获取卡券类型可以作用的服务id
     *
     * @param couponId 卡券类型id
     * @return
     */
    List<Integer> queryCouponCustomerServeRelevance(Integer couponId);

    List<CouponCustomerRelevance> selectByOrderTimes();
}
