package com.gogirl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.gogirl.application.market.CouponCustomerRelevanceService;
import com.gogirl.application.market.TimesCardCustomerRelevanceService;
import com.gogirl.application.market.TimesCardUsedRecordService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;
import com.gogirl.domain.order.pay.OrderPay;
import com.gogirl.domain.order.serve.MultiPaymentType;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.domain.store.complaint.ComplaintDetailed;
import com.gogirl.domain.store.complaint.ComplaintDetailedTechnician;
import com.gogirl.domain.store.complaint.ComplaintMain;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.domain.xcx.TimeNode;
import com.gogirl.domain.xcx.WeekConfig;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.mapper.market.coupon.CouponCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.market.discount.LeisureDiscountConfigWeekMapper;
import com.gogirl.infrastructure.mapper.market.timescard.TimesCardCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.order.pay.OrderPayMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderServeMapper;
import com.gogirl.infrastructure.mapper.store.complaint.ComplaintDetailedMapper;
import com.gogirl.infrastructure.mapper.store.complaint.ComplaintDetailedTechnicianMapper;
import com.gogirl.infrastructure.mapper.store.complaint.ComplaintMainMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import com.gogirl.infrastructure.mapper.xcx.TimeNodeMapper;
import com.gogirl.infrastructure.mapper.xcx.WeekConfigMapper;
import lombok.extern.slf4j.Slf4j;
import org.assertj.core.util.Lists;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
public class Test {

    @Resource
    private TimeNodeMapper timeNodeMapper;

    @org.junit.Test
    public void timeNode() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LocalTime localTime = LocalTime.of(0, 0);
        LocalTime localTime2 = LocalTime.of(23, 45);


        while (localTime.compareTo(localTime2) < 0) {
            TimeNode timeNode = new TimeNode();
            timeNode.setTimeNode(localTime);
            timeNodeMapper.insert(timeNode);
            localTime = localTime.plusMinutes(15);
        }
    }

    @Resource
    private LeisureDiscountConfigWeekMapper leisureDiscountConfigWeekMapper;
    @Resource
    private WeekConfigMapper weekConfigMapper;

    @org.junit.Test
    public void weekTest() throws ParseException {

        weekConfigMapper.delete(new LambdaQueryWrapper<>());

        LocalDate localDate = LocalDate.now();
        for (int i = 0; i < 7; i++) {
            WeekConfig weekConfig = new WeekConfig();
            weekConfig.setWeek(localDate.getDayOfWeek().getValue());
            weekConfig.setWeekStr(localDate.getDayOfWeek().toString());
            weekConfig.setWeekDate(localDate);
            weekConfigMapper.insert(weekConfig);
            localDate = localDate.plusDays(1);
        }
    }

    @Resource
    OrderPayMapper orderPayMapper;
    @Resource
    OrderManageMapper orderManageMapper;
    @Resource
    CouponCustomerRelevanceMapper couponCustomerRelevanceMapper;

    @org.junit.Test
    public void orderPay() {

        orderPayMapper.delete(new LambdaQueryWrapper<>());

        List<OrderManage> orderManageList = orderManageMapper.selectList(new LambdaQueryWrapper<OrderManage>()
                .gt(OrderManage::getFinishTime, "2020-01-01"));


        // order_pay 微信 = 1, 会员 = 2, 充值 = 4, pos机 = 5, 大众点评 = 7, 会员帮付 = 11, 次卡 =12
        //1#微信 2#会员 3#其他4#充值5#pos机6#现金7#大众点评8#微信扫码支付9#团购10#免单11#会员帮付12#余额抵扣微信支付13余额pos支付
        orderManageList.forEach(orderManage -> {
            if (orderManage.getPaymentType().equals(1)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(orderManage.getTotalPaymentAmount());
                orderPay.setOrderId(orderManage.getId());
                orderPay.setType(1);
                orderPayMapper.insert(orderPay);
            }
            if (orderManage.getPaymentType().equals(2)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(orderManage.getTotalPaymentAmount());
                orderPay.setOrderId(orderManage.getId());
                orderPay.setType(2);
                orderPayMapper.insert(orderPay);
            }
            if (orderManage.getPaymentType().equals(5)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(orderManage.getTotalPaymentAmount());
                orderPay.setOrderId(orderManage.getId());
                orderPay.setType(5);
                orderPayMapper.insert(orderPay);
            }

            if (orderManage.getPaymentType().equals(12) || orderManage.getPaymentType().equals(13)) {

                try {
                    List<MultiPaymentType> multiPaymentTypeList = JsonUtilByFsJson.jsonToList(orderManage.getMultiplePaymentType(), MultiPaymentType.class);
                    multiPaymentTypeList.forEach(multiPaymentType -> {
                        if (multiPaymentType.getType().equals(1)) {
                            OrderPay orderPay = new OrderPay();
                            orderPay.setAmount(multiPaymentType.getPrice());
                            orderPay.setOrderId(orderManage.getId());
                            orderPay.setType(1);
                            orderPayMapper.insert(orderPay);
                        }
                        if (multiPaymentType.getType().equals(2)) {
                            OrderPay orderPay = new OrderPay();
                            orderPay.setAmount(multiPaymentType.getPrice());
                            orderPay.setOrderId(orderManage.getId());
                            orderPay.setType(2);
                            orderPayMapper.insert(orderPay);
                        }

                        if (multiPaymentType.getType().equals(5)) {
                            OrderPay orderPay = new OrderPay();
                            orderPay.setAmount(multiPaymentType.getPrice());
                            orderPay.setOrderId(orderManage.getId());
                            orderPay.setType(5);
                            orderPayMapper.insert(orderPay);
                        }
                    });
                } catch (Exception e) {
                    log.error("orderId:no multi :{}", orderManage.getId());
                }
            }
        });

        orderPayMapper.delete(new LambdaQueryWrapper<OrderPay>().eq(OrderPay::getAmount, 0));
    }


    @org.junit.Test
    public void customerPay() {

        List<CouponCustomerRelevance> couponCustomerRelevanceList = couponCustomerRelevanceMapper.selectByOrderTimes();

        couponCustomerRelevanceList.forEach(couponCustomerRelevance -> {
            if (couponCustomerRelevance.getSourceType().equals(1)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(couponCustomerRelevance.getPayAmount());
                orderPay.setOrderId(couponCustomerRelevance.getOrderId());
                orderPay.setType(7);
                orderPayMapper.insert(orderPay);
            }
        });
    }

    @Resource
    RedisTemplate<String, String> redisTemplate;
    @Resource
    GogirlTokenService gogirlTokenService;
    @Resource
    CustomerMapper customerMapper;

    @org.junit.Test
    public void values() {
        Customer customer = customerMapper.selectById(20432);
        GogirlToken gogirlToken = GogirlToken.builder()
                .token(20432 + "_" + IdWorker.getIdStr().substring(6))
                .createTime(new Date())
                .openid(customer.getOpenid1())
                .customerId(20432)
                .build();
        gogirlTokenService.save(gogirlToken);
        System.out.println(gogirlToken.getToken());
    }

    @Resource
    ComplaintDetailedMapper complaintDetailedMapper;
    @Resource
    OrderServeMapper orderServeMapper;
    @Resource
    ComplaintMainMapper complaintMainMapper;
    @Resource
    ComplaintDetailedTechnicianMapper complaintDetailedTechnicianMapper;
    @Resource
    TimesCardCustomerRelevanceMapper timesCardCustomerRelevanceMapper;

    @org.junit.Test
    public void complain() {
        List<ComplaintDetailed> complaintDetailedList = complaintDetailedMapper.complainTest();

        complaintDetailedList.forEach(complaintDetailed -> {

            ComplaintMain complaintMain = complaintMainMapper.selectById(complaintDetailed.getMainId());
            List<Integer> technicianIds = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>()
                    .eq(OrderServe::getOrderId, complaintMain.getOrderId()))
                    .stream()
                    .map(OrderServe::getTechnicianId)
                    .map(id -> Lists.newArrayList(id.split(",")))
                    .flatMap(List::stream)
                    .map(Integer::valueOf)
                    .collect(Collectors.toList());
            technicianIds.forEach(technicianId -> {
                ComplaintDetailedTechnician complaintDetailedTechnician = new ComplaintDetailedTechnician();
                complaintDetailedTechnician.setTechnicianId(technicianId);
                complaintDetailedTechnician.setComplaintDetailedId(complaintDetailed.getId());
                complaintDetailedTechnicianMapper.insert(complaintDetailedTechnician);
            });

        });
    }

    @Resource
    CouponCustomerRelevanceService couponCustomerRelevanceService;
    @Resource
    TimesCardUsedRecordService timesCardUsedRecordService;
    @Resource
    TimesCardCustomerRelevanceService timesCardCustomerRelevanceService;

//    public void orderAch() {
//        List<OrderManage> orderManageList = orderManageMapper.selectList(new LambdaQueryWrapper<OrderManage>()
//                .in(OrderManage::getStatus, Lists.newArrayList(3, 4))
//                .ge(OrderManage::getCreateTime, "2020-03-01"));
//        orderManageList.forEach(orderManage -> {
//            Integer orderId = orderManage.getId();
//            //订单使用的内部券
//            List<CouponCustomerRelevance> innerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
//                    .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
//                            .eq(CouponCustomerRelevance::getOrderId, orderId)
//                            .eq(CouponCustomerRelevance::getState, 1)
//                            .eq(CouponCustomerRelevance::getSourceType, 0));
//
//            //订单使用的外部券
//            List<CouponCustomerRelevance> outerCouponCustomerRelevanceServiceList = couponCustomerRelevanceService
//                    .list(new LambdaQueryWrapper<CouponCustomerRelevance>()
//                            .eq(CouponCustomerRelevance::getOrderId, orderId)
//                            .eq(CouponCustomerRelevance::getState, 1)
//                            .eq(CouponCustomerRelevance::getSourceType, 1));
//
//
//            //订单使用的次卡
//            List<TimesCardUsedRecord> timesCardUsedRecordList = timesCardUsedRecordService
//                    .list(new LambdaQueryWrapper<TimesCardUsedRecord>()
//                            .eq(TimesCardUsedRecord::getOrderId, orderId)
//                            .eq(TimesCardUsedRecord::getStatus, 1));
//
//
//            //查询订单聚合
//
//            List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, orderId));
//            orderManage.setListOrderServer(orderServeList);
//            orderServeList.forEach(orderServe -> {
//                orderServe.setBindInnerCoupon(2);
//                orderServe.setBindTimesCard(2);
//                orderServe.setBindOuterCoupon(2);
//            });
//
//            //1.改价结算
//            //总支付金额等于 总价格+总改价
//            orderManage.setTotalPaymentAmount(orderManage.getTotalPrice().add(orderManage.getChangePrice()));
//            //总折扣金额
//            orderManage.setDiscountPrice(BigDecimal.ZERO);
//
//            orderManage.getListOrderServer().forEach(orderServe -> {
//                //服务实际支付金额=服务价格+服务改价
//                orderServe.setPayPrice(orderServe.getPrice().add(orderServe.getServeChangePrice()));
//                //服务折金额=0
//                orderServe.setDiscountPrice(BigDecimal.ZERO);
//                //业绩的实际支付金额
//                orderServe.setAchievement(orderServe.getPrice().add(orderServe.getServeChangePrice()));
//            });
//
//            //3.次卡
//            if (ListUtil.isNotEmpty(timesCardUsedRecordList)) {
//                //次卡使用记录
//                timesCardUsedRecordList.forEach(timesCardUsedRecord -> timesCardUsedRecord.setStatus(TimesCardUsedRecord.STATUS_CHOSE));
//
//                timesCardUsedRecordList.stream()
//                        .sorted(Comparator.comparing(TimesCardUsedRecord::getDiscountAmount))
//                        .forEach(timesCardUsedRecord -> {
//
//
//                            //次卡能用的服务id
//                            List<Integer> serveIds = timesCardCustomerRelevanceMapper.queryTimesCardServeIds(timesCardUsedRecord.getCardTypeId());
//                            //抵扣的服务为 作用范围内支付金额最高的服务
//                            OrderServe orderServe = this.queryMaxPayPrice(orderManage, serveIds);
//                            if (orderServe != null) {
//
//                                BigDecimal actualDiscountAmount = orderServe.getPayPrice().min(timesCardUsedRecord.getDiscountAmount());
//                                //更新次卡记录 已使用
//                                timesCardUsedRecord.setStatus(TimesCardUsedRecord.STATUS_USED);
//                                //次卡对应订单服务的美甲师
//                                timesCardUsedRecord.setTechnicianName(orderServe.getTechnicianName());
//                                //次卡店铺名称
//                                timesCardUsedRecord.setDepartmentName(orderManage.getDepartmentName());
//                                //次卡店铺id
//                                timesCardUsedRecord.setDepartmentId(orderManage.getDepartmentId());
//                                //次卡折扣的
//                                timesCardUsedRecord.setServeName(orderServe.getServeName());
//                                //次卡作用的服务id
//                                timesCardUsedRecord.setOrderServeId(orderServe.getServeId());
//                                timesCardUsedRecord.setOrderId(orderId);
//                                timesCardUsedRecord.setActualDiscountAmount(actualDiscountAmount);
//
//                                //在主服务上折扣的钱
//                                TimesCardOrderServeDetail timesCardOrderServeDetail = new TimesCardOrderServeDetail();
//                                timesCardOrderServeDetail.setDiscountAmount(actualDiscountAmount);
//                                timesCardOrderServeDetail.setOrderServeId(orderServe.getId());
//                                timesCardOrderServeDetail.setOrderId(orderId);
//                                timesCardOrderServeDetail.setTimesCardUserRecordId(timesCardUsedRecord.getOrderServeId());
//                                //业绩
//                                timesCardOrderServeDetail.setAchievement(timesCardUsedRecord.getPayAmount());
//
//                                //订单折扣金额更新
//                                orderServe.setBindTimesCard(1);
//                                orderServe.addDiscountPrice(actualDiscountAmount);
//
//                                //业绩
//                                orderServe.setAchievement(orderServe.getAchievement().subtract(actualDiscountAmount).add(timesCardUsedRecord.getPayAmount()));
//                                orderManage.addDiscountPrice(actualDiscountAmount);
//
//                                //更新使用次数
//                                TimesCardCustomerRelevance timesCardCustomerRelevance = timesCardCustomerRelevanceService.getById(timesCardUsedRecord.getCardRelevanceCustomerId());
//                                timesCardCustomerRelevance.setUsedTimes(timesCardCustomerRelevance.getUsedTimes() + 1);
//                                if (timesCardCustomerRelevance.getUsedTimes().equals(timesCardCustomerRelevance.getSumTimes())) {
//                                    //次数用完
//                                    timesCardCustomerRelevance.setStatus(2);
//                                }
//                                timesCardCustomerRelevanceService.updateById(timesCardCustomerRelevance);
//                            } else {
//                                throw new RRException("次卡冲突");
//                            }
//
//                        });
//            }
//
//
//            //4。外部券
//            if (ListUtil.isNotEmpty(outerCouponCustomerRelevanceServiceList)) {
//
//
//
//                outerCouponCustomerRelevanceServiceList
//                        .stream()
//                        .sorted(Comparator.comparing(CouponCustomerRelevance::getDiscountAmount).reversed())
//                        .forEach(couponCustomerRelevance -> {
//
//
//                            //外部券能用的服务id
//                            List<Integer> serveIds = couponCustomerRelevanceMapper.queryCouponCustomerServeRelevance(couponCustomerRelevance.getCouponId());
//
//                            //抵扣的服务为 作用范围内支付金额最高的服务
//                            OrderServe orderServe = this.queryMaxPayPrice(orderManage, serveIds);
//
//                            if (orderServe != null) {
//                                //如果有属于这个服务的辅助服务 就查出来一起折扣
//                                OrderServe supportServe = this.querySupportServe(orderManage, orderServe);
//
//                                BigDecimal actualDiscountAmount = orderServe.getPayPrice().min(couponCustomerRelevance.getDiscountAmount());
//
//                                //新增外部券抵扣情况记录
//                                CouponOrderRelevance couponOrderRelevance = CouponOrderRelevance.builder()
//                                        .couponCustomerRelevanceId(couponCustomerRelevance.getId())
//                                        .couponId(couponCustomerRelevance.getCouponId())
//                                        .couponName(couponCustomerRelevance.getCouponName())
//                                        .orderServeId(orderServe.getId())
//                                        .serveName(orderServe.getServeName())
//                                        .orderId(orderManage.getId())
//                                        //支付金额
//                                        .payForOrderServe(couponCustomerRelevance.getPayAmount())
//                                        //折扣金额
//                                        .discountAmount(actualDiscountAmount)
//                                        .createTime(new Date())
//                                        .confirmTime(new Date())
//                                        .message(orderServe.getServeName())
//                                        .customerId(orderManage.getOrderUser())
//                                        .status(2)
//                                        .build();
//                                //如果计算业绩
//                                if (couponCustomerRelevance.getIsCalcAchievement() == 1) {
//                                    couponOrderRelevance.setAchievement(couponCustomerRelevance.getPayAmount());
//                                } else {
//                                    couponOrderRelevance.setAchievement(couponOrderRelevance.getDiscountAmount());
//                                }
//
//                                //业绩
//                                orderServe.setAchievement(orderServe.getAchievement().subtract(actualDiscountAmount).add(couponCustomerRelevance.getPayAmount()));
//
//                                orderServe.addDiscountPrice(actualDiscountAmount);
//                                orderManage.addDiscountPrice(actualDiscountAmount);
//                                orderServe.setBindOuterCoupon(1);
//                                couponOrderRelevanceService.save(couponOrderRelevance);
//
//                            } else {
//                                throw new RRException("外部券冲突");
//                            }
//
//                        });
//            }
//            //5.内部券
//            if (ListUtil.isNotEmpty(innerCouponCustomerRelevanceServiceList)) {
//
//                innerCouponCustomerRelevanceServiceList
//                        .forEach(couponCustomerRelevance -> {
//                            //内部券能用的服务id
//                            List<Integer> serveIds = couponCustomerRelevanceMapper.queryCouponCustomerServeRelevance(couponCustomerRelevance.getCouponId());
//
//                            //作用的服务id
//                            List<OrderServe> canUserOrderServeList = this.queryCanDiscount(orderManage, serveIds, couponCustomerRelevance.getCouponId());
//
//                            //打折订单项总支付金额
//                            BigDecimal total = canUserOrderServeList.stream().map(OrderServe::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
//
//                            if (!total.setScale(2, BigDecimal.ROUND_HALF_UP).equals(BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP))) {
//                                //卡券的总折扣金额
//                                BigDecimal totalCouponDiscount = couponCustomerRelevance.getDiscountAmount();
//                                //卡券总支付金额
//                                BigDecimal totalCouponPay = couponCustomerRelevance.getPayAmount();
//
//                                //计算参数（最后一个订单服务的折扣金额要用总折扣金额减 防止除法计算精度问题）
//                                BigDecimal discountCalc = BigDecimal.ZERO;
//
//                                //计算参数（最后一个订单服务的实际支付要用总实际支付金额减 防止除法计算精度问题）
//                                BigDecimal payCalc = BigDecimal.ZERO;
//
//                                for (OrderServe orderServe : canUserOrderServeList) {
//
//                                    //每个服务的内部券抵扣金额
//                                    BigDecimal discountAmount = orderServe.getPayPrice().multiply(totalCouponDiscount).divide(total, 2, BigDecimal.ROUND_HALF_UP);
//                                    //每个服务的卡券实际支付金额
//                                    BigDecimal payAmount = orderServe.getPayPrice().multiply(totalCouponPay).divide(total, 2, BigDecimal.ROUND_HALF_UP);
//
//
//                                    //最后一个服务使用总额减法而不是除法
//                                    if (canUserOrderServeList.lastIndexOf(orderServe) == canUserOrderServeList.size() - 1) {
//                                        discountAmount = totalCouponDiscount.subtract(discountCalc);
//                                        payAmount = totalCouponPay.subtract(payCalc);
//                                    }
//                                    BigDecimal actualDiscountAmount = discountAmount.min(orderServe.getPayPrice());
//
//                                    //卡券在订单服务上的抵扣情况
//                                    CouponOrderRelevance couponOrderRelevance = CouponOrderRelevance.builder()
//                                            .discountAmount(actualDiscountAmount)
//                                            //卡券在这个服务上的实际支付金额
//                                            .payForOrderServe(payAmount)
//                                            .createTime(new Date())
//                                            .orderServeId(orderServe.getId())
//                                            .orderId(orderManage.getId())
//                                            .couponId(couponCustomerRelevance.getCouponId())
//                                            .couponCustomerRelevanceId(couponCustomerRelevance.getId())
//                                            .confirmTime(new Date())
//                                            .message(orderServe.getServeName())
//                                            .customerId(orderManage.getOrderUser())
//                                            .status(2)
//                                            .build();
//
//                                    //如果计算业绩
//                                    if (couponCustomerRelevance.getIsCalcAchievement() == 1) {
//                                        couponOrderRelevance.setAchievement(couponCustomerRelevance.getPayAmount());
//                                    } else {
//                                        couponOrderRelevance.setAchievement(couponOrderRelevance.getDiscountAmount());
//                                    }
//
//                                    //免单券Id
//                                    List<Integer> discountConfigListCouponId = discountConfigMapper.selectList(new QueryWrapper<>()).stream().map(DiscountConfig::getCouponId).filter(Objects::nonNull).collect(Collectors.toList());
//                                    //如果不是免单券 业绩就要扣除实际折扣金额
//                                    if (!discountConfigListCouponId.contains(couponCustomerRelevance.getCouponId())) {
//                                        orderServe.setAchievement(orderServe.getAchievement().subtract(actualDiscountAmount));
//                                    }
//
//                                    orderServe.addDiscountPrice(actualDiscountAmount);
//                                    orderManage.addDiscountPrice(actualDiscountAmount);
//
//                                    orderServe.setBindInnerCoupon(1);
//                                    discountCalc = discountCalc.add(discountAmount);
//                                    payCalc = payCalc.add(payAmount);
//                                }
//                            }
//                            //内部券抵扣不了
//                            else {
//                                throw new RRException("内部券冲突");
//                            }
//                        });
//            }
//        });
//    }

}
