package com.gogirl.application.xcx.impl;


import com.gogirl.infrastructure.config.property.WxProperties;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;


@Service
@Slf4j
@AllArgsConstructor
public class AccessTokenService {
    private final WxProperties wxProperties;

    /**
     * 获取accessToken
     *
     * @return accessToken
     */
    public AccessToken getAccessToken() {
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + wxProperties.getCustomerMiniAppId() + "&secret=" + wxProperties.getCustomerMiniSecret();

        RestTemplate restTemplate = new RestTemplate();

        String response = restTemplate.getForEntity(url, String.class).getBody();

        JSONObject json = JSONObject.fromObject(response);

        System.out.println(json.toString());
        AccessToken token = new AccessToken();

        token.setAccessToken(json.getString("access_token"));
        token.setExpiresIn(new Integer(json.getString("expires_in")));
        return token;
    }

}
