package com.gogirl.shared.order;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@Data
@ApiModel("预下单订单详情")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MallOrderDetailDTO {

    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("订单id")
    private Long orderId;

    @ApiModelProperty("商定的id")
    private Long productId;

    @ApiModelProperty("数量")
    private Integer num;

    /**
     * 冗余Product字段
     */
    private String productSku;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("商品封面图")
    private String coverImages;

    @ApiModelProperty("商品价格")
    private BigDecimal price;

    @ApiModelProperty("商品规格")
    private String specification;

    @ApiModelProperty("规格单位")
    private String unit;


    /**
     *
     */
    @ApiModelProperty("订单详情总金额")
    private BigDecimal amount;

    @ApiModelProperty("详情优惠金额")
    private BigDecimal discountAmount;

    @ApiModelProperty("详情支付总金额")
    private BigDecimal payAmount;
}
