package com.gogirl.interfaces.market.coupon;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.application.market.coupon.CouponCustomerRelevanceService;
import com.gogirl.application.market.coupon.MarketService;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.util.SessionUtils;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

@RestController
@AllArgsConstructor
@Slf4j
@Api(tags = {"优惠券接口"}, value = "优惠券接口")
public class CouponCustomerRelevanceController {

    private final CouponCustomerRelevanceService couponCustomerRelevanceService;
    private final MarketService marketService;

    @ApiOperation(value = "用户根据订单号查询可用优惠券")
    @GetMapping("/customer/getOrderCoupon")
    public JsonResult<List<CouponCustomerRelevance>> getOrderCoupon(@RequestParam Integer orderId) {

        Integer currentCustomerId = SessionUtils.getCustomerToken().getCustomerId();
        List<CouponCustomerRelevance> list = couponCustomerRelevanceService.getOrderCoupon(currentCustomerId, orderId);
        return JsonResult.success(list);
    }

    @ApiOperation(value = "我的优惠券列表")
    @GetMapping("/customer/getMyCoupon")
    public JsonResult<IPage<CouponCustomerRelevance>> getMyCoupon(@RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                                  @RequestParam Integer state) {
        Integer customerId = SessionUtils.getCustomerId();
        IPage<CouponCustomerRelevance> pageInfo = couponCustomerRelevanceService.selectMyCoupon(customerId, pageNum, pageSize, state);
        return JsonResult.success(pageInfo);
    }

    @ApiOperation(value = "美甲师提交外部券")
    @PostMapping("/technician/techSubmitCoupons")
    public JsonResult<Void> techSubmitCoupons(@RequestParam Integer orderId,
                                              @RequestParam String couponIds) {
        List<Integer> idList = StringUtils.isNotEmpty(couponIds) ? Lists.newArrayList(couponIds.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList()) : Lists.newArrayList();
        couponCustomerRelevanceService.techSubmitCoupons(orderId, idList);
        return JsonResult.success();
    }


    @Transactional
    @ApiOperation(value = "用户提交优惠券")
    @PostMapping(value = "/customer/submitCoupons")
    public JsonResult<Void> submitCoupons(@RequestParam Integer orderId,
                                          @RequestParam String couponRelevanceIds,
                                          @RequestParam String timesCardIds) {

        log.info("用户提交优惠券 orderId:{},couponIds:{}", orderId, couponRelevanceIds);

        //1、使用内部券
        List<Integer> innerCouponIds = StringUtils.isNotEmpty(couponRelevanceIds) ? Lists.newArrayList(couponRelevanceIds.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList()) : Lists.newArrayList();
        marketService.setUpInnerCoupon(orderId, innerCouponIds);

        //2、使用外部券
        List<Integer> timesCardCustomerIds = StringUtils.isNotEmpty(timesCardIds) ? Lists.newArrayList(timesCardIds.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList()) : Lists.newArrayList();
        marketService.setTimesCard(orderId, timesCardCustomerIds);

        //3、订单结算
        marketService.calcOrderAmount(orderId);
        return JsonResult.success();
    }

}
