package com.gogirl.application.market.coupon;

import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.market.coupon.Coupon;
import com.gogirl.infrastructure.common.exception.RRException;

import java.util.Collection;
import java.util.List;


public interface CouponService extends IService<Coupon> {


    /**
     * 是否新人
     *
     * @param customerId
     * @return
     */
    Coupon checkNewCustomer(Integer customerId);

    /**
     * 发放新人券
     *
     * @param customerId 用户id
     * @return
     */
    Coupon sendNewCustomerCouponXcx(Integer customerId);

    /**
     * 全局统一发券接口
     *
     * @param couponId   卡券配置id
     * @param customerId 用户id
     * @return
     */
    Coupon sendCoupon(Integer couponId, Integer customerId);

    /**
     * 查询订单可用外部券
     *
     * @param orderId
     * @return
     */
    List<Coupon> getOrderExternalCoupon(Integer orderId);

    /**
     * 卡券集合中是否存在冲突的卡券
     *
     * @param couponIdList 卡券配置id
     * @return
     */
    Boolean existCouponConflict(Collection<Integer> couponIdList);


    /**
     * 卡券集合中是否存在冲突的卡券 如果存在 抛出异常
     *
     * @param couponIdList 卡券配置id
     * @return
     */
    void checkCouponConflict(Collection<Integer> couponIdList) throws RRException;



}
