package com.gogirl.infrastructure.mapper.market.discount;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gogirl.domain.market.discount.LeisureDiscountConfigLimit;
import com.gogirl.shared.product.LeisureScheduleServeResp;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.time.LocalTime;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-07-06
 */
public interface LeisureDiscountConfigLimitMapper extends BaseMapper<LeisureDiscountConfigLimit> {

    void syncWeekConfigLimit();

    LeisureDiscountConfigLimit selectConfigLimit(String date, Integer leisureDiscountConfigId);


    LeisureScheduleServeResp selectOneLeisureDiscountConfig(@Param("leisureDiscountConfigId") Integer leisureDiscountConfigId,
                                                            @Param("serveId") Integer serveId,
                                                            @Param("time") LocalTime time,
                                                            @Param("date") LocalDate date);

}
