package com.gogirl.infrastructure.feign.wx;

import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.shared.wx.WxSubscribeMessageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author robbendev
 * @Description //TODO
 * @Date 2019/12/29
 **/
@Component
@Slf4j
public class WxSubscribeController implements WxSubscribeControllerFeign {


    @Override
    public <T> JsonResult<Void> send(@RequestBody WxSubscribeMessageRequest<T> request) {

        String url = "https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=" + request.getAccessToken();

        Map<String, Object> map = new HashMap<>();
        map.put("data", request.getData());
        map.put("template_id", request.getTemplateId());
        map.put("touser", request.getToUser());
        map.put("page", request.getPage());

        log.info("推送订阅消息参数：{}", JsonUtilByFsJson.beanToJson(map));

        String jsonResp = new RestTemplate().postForEntity(url, map, String.class).getBody();

        log.info("推送订阅消息响应：{}", jsonResp);
        return JsonResult.success();
    }
}
