package com.gogirl.infrastructure.mapper.market;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gogirl.domain.market.discount.LeisureDiscountConfig;
import com.gogirl.domain.product.serve.BaseServe;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;


public interface LeisureDiscountConfigMapper extends BaseMapper<LeisureDiscountConfig> {


    /**
     * 获取店铺对应星期数的打折服务列表
     *
     * @param departmentId 店铺id
     * @param week         周几
     * @return 服务列表
     */
    List<BaseServe> selectByDepartmentId(@Param("departmentId") Integer departmentId, @Param("week") int week);

    /**
     * 获取折扣最低的闲时折扣
     *
     * @return discount
     */
    LeisureDiscountConfig queryMinDiscount();

    /**
     * 获取时间，服务，周几对应的折扣
     *
     * @param time      时间形如'10:00'
     * @param serviceId 服务id
     * @param weekday   周几
     * @return 折扣列表
     */
    LeisureDiscountConfig selectLeisureDiscount(@Param("serviceId") Integer serviceId, @Param("time") String time, @Param("weekday") int weekday);


    /**
     * 获取店铺id，星期数，时间段形如'10:00'对应的折扣列表 忽略剩余次数条件
     *
     * @param departmentId 店铺Id
     * @param finalWeekday 星期几
     * @param time         时间形如
     * @return list
     */
    List<BaseServe> selectByDepartmentIdAndWeekAndDateTime(@Param("departmentId") Integer departmentId, @Param("week") int finalWeekday, @Param("time") String time);

    /**
     * 获取店铺id，星期数对应的折扣列表 忽略剩余次数条件
     *
     * @param departmentId 店铺Id
     * @param weekday      星期几
     * @return list
     */
    List<LeisureDiscountConfig> selectByDepartmentIdAndWeekIgnoreLimit(@Param("departmentId") Integer departmentId, @Param("week") int weekday);


    /**
     * 获取时间，服务，周几对应的折扣列表
     *
     * @param time    时间形如'10:00'
     * @param serveId 服务id
     * @param weekday 周几
     * @return 折扣列表
     */
    List<LeisureDiscountConfig> selectIsLeisureTime(String time, Integer serveId, int weekday);
}
